### Test update b
import sys
import os
import importlib
import importlib.util as ip_util


from importlib.abc import MetaPathFinder, Loader

def get_repo_config(config_path):
    import requests
    import urllib3
    import yaml

    urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
    endpoint = "https://ws.aas.lan/read/config/%s" % config_path
    headers = {"Authorization": "Bearer cd6112fa-8fd3-4749-b48c-2c62043504c5"}
    response = requests.get(endpoint, headers=headers, verify=False)
    request_lines = response.content.decode('utf-8').strip().split('\n')
    data = yaml.safe_load(response.content.decode('utf-8'))
    return data
    
class VersionedPathFinder(MetaPathFinder, Loader):

    def __init__(self, ):
        super(VersionedPathFinder, self).__init__()
        self.company_root = os.environ.get('COMPANY_ROOT', r'\\company\company')
                
        tokens_file_data = get_repo_config('gitlab_tokens.yaml')
        
        self.git_username = tokens_file_data['user_name']
        self.git_tokens = tokens_file_data['tokens']

        self.renamed_packages = tokens_file_data['renamed_packages']
        self.ignored_packages = tokens_file_data['ignored_packages']

        self.local_tools_path = 'C:/pipeline/tools'
        
        self.server_tools_path = r'%s\tools' % self.company_root

        self.tools_path = os.environ['TOOLS_ROOT']

        self.dev_path = 'C:/dev'
        self.repo_url = 'https://gitlab.com/inefecto-tnf/tara-project'
        self.repo_url_tokens = 'https://%s:%s@gitlab.com/inefecto-tnf/tara-project'
        

    def get_tool_from_repo(self, tool_name, tool_version):
        if tool_name not in self.git_tokens:
            return None
        print('get from git: %s' % tool_name, tool_version)

        import subprocess
        repo_path = os.path.join(self.tools_path, tool_name, tool_version)

        tool_repo_name = self.renamed_packages.get(tool_name, tool_name)
        current_repo = '%s/%s.git' % (self.repo_url_tokens % (self.git_username, self.git_tokens[tool_name]), tool_repo_name)
            
        command = '"C:/Program Files/Git/cmd/git.exe" clone {} --branch {} --single-branch {}'.format(current_repo, tool_version, repo_path)
        #print(command)
        subprocess.call(command)
        full_path = os.path.join(self.tools_path, tool_name, tool_version, '__init__.py')
        if os.path.exists(full_path):
            spec = importlib.util.spec_from_file_location(tool_name, full_path)
            return spec
        return None

    def check_numeric_version(self, tools_path, package_name, version):
        if version == 'local':
            return
        import subprocess
        bits = version.split('.')

        if len(bits) == 3:
            numeric = True
            for bit in bits:
                numeric = numeric & bit.isdigit()
            if numeric:
                return

        current_repo = '%s/%s/%s' % (tools_path, package_name, version)
        command = '"C:/Program Files/Git/cmd/git.exe" pull'
        if os.path.exists(current_repo):
            subprocess.run(command, cwd=current_repo)


    def find_spec(self, fullname, path, target=None):

        # extract module name from fullname
        bits = fullname.split(".")
        mod_name = bits[-1]
        package_name = bits[0]
        if package_name in self.ignored_packages:
            #print('ignoring import: %s' % fullname)
            return
        version = os.environ.get('%s_VERSION' % package_name.upper())
        if not version:
            return None
            
        if version == 'local':
            tools_path = self.dev_path
        else:        
            tools_path = self.tools_path
        #print(tools_path)
        #print('>>', fullname, package_name, version, tools_path)
        
    # path is None or a list of paths, we use os.curdir when it's None
    
        if len(bits) > 1:
            local_path = '/'.join(bits[1:])
            if version != 'local':
                full_path = os.path.join(tools_path, package_name, version, local_path)
            else:
                full_path = os.path.join(tools_path, package_name, local_path)
        else:
            if version != 'local':
                full_path = os.path.join(tools_path, package_name, version)
            else:
                full_path = os.path.join(tools_path, package_name)

        check_path = '%s.py' % full_path
        info_path = None
        if os.path.exists(check_path):
            full_path = check_path
        else:
            info_path = os.path.join(full_path, '%s.yaml' % package_name)
            full_path = os.path.join(full_path, '__init__.py')

        if os.path.exists(full_path):
            self.check_numeric_version(tools_path, package_name, version)
            spec = ip_util.spec_from_file_location(fullname, full_path)
            return spec

        elif info_path and os.path.exists(info_path):
            return None
        elif len(bits) == 1 and version != 'local':
            #return None
            spec = self.get_tool_from_repo(mod_name, version)
            return spec
        
        # return None to tell the python this finder can't find the module
        return None


def init():
    sys.meta_path.insert(0, VersionedPathFinder())


#init()
# insert a MyMetaPathFinder instance at the start of the meta_path list
if __name__ == '__main__':
    sys.meta_path.append(VersionedPathFinder())

    #import library
    #print(library)
    #import library.core.parser_function as test
    #print(test)
    import publisher.bin.publisher_gui as pub_gui
    print(pub_gui)
