import importlib
from pprint import pprint

import warnings

import shotgrid_lib.database as database
import research_pantry.scripts.rename_usd_recursive as  rename_usd_recursive
importlib.reload(rename_usd_recursive)



def update_usd_assemblies(project, entity_name=None, entity='Asset'):
    import usd.lib.usd_manager as usd_manager
    importlib.reload(usd_manager)

    sg_database = database.DataBase()
    sg_database.fill(project, precatch=False)
    sg_database.query_sg_database(entity)

    for asset_view in sg_database[entity]:
        if entity_name is not None and asset_view.code != entity_name:
            continue

        if entity == 'Asset':
            print(asset_view.code, asset_view.sg_asset_type)
            asset_type = asset_view.sg_asset_type.replace(' ', '_')
            #if asset_type != 'Sets':
            #    continue

        else:
            print(asset_view.code)
            asset_type = None

        manager = usd_manager.UsdManager(project)

        manager.set_entity(asset_view.code, entity, asset_type=asset_type)
        filename = manager.filename
        manager.open(filename)
        manager.create_entity_assembly()
        asset_view.precache_dependencies(fields=['sg_published_elements'])
        asset_versions = {}
        for publish in asset_view.sg_published_elements:
            if publish.sg_delete or not publish.sg_complete:
                continue
            if 'usd' not in publish.sg_files:
                continue
            step = publish.sg_step_name
            variant = publish.sg_variant_name
            version = publish.sg_version_number
            version_path = '%s/%s' % (publish.sg_published_folder, publish.sg_files['usd'])
            version_path = version_path.lower()
            if version_path.startswith('v:/'):
                version_path = version_path.replace('v:/', r'\\project/SGD/')

            asset_versions[step] = asset_versions.get(step, {})
            asset_versions[step][variant] = asset_versions[step].get(variant, {})
            asset_versions[step][variant][version] = version_path
            #try:
            #    rename_usd_recursive.rename_usd_paths(version_path)
            #except:
            #    continue

            if publish.sg_status_list == 'apr':
                asset_versions[step][variant]['approved'] = version_path
                asset_versions[step][variant]['recommended'] = version_path

            numeric_versions = [version for version in asset_versions[step][variant].keys() if isinstance(version, int)]
            latest_version = max(numeric_versions)
            latest_version_path = asset_versions[step][variant][latest_version]
            asset_versions[step][variant]['latest'] = latest_version_path

            if 'approved' not in asset_versions[step][variant]:
                asset_versions[step][variant]['recommended'] = latest_version_path
        manager.build_asset(asset_versions)
        pprint(asset_versions)


if __name__ == '__main__':
    #update_usd_assemblies('tpt', entity_name='Tentacle',entity='Asset')
    update_usd_assemblies('sgd', entity='Asset', entity_name='streetLight')
    #update_usd_assemblies('tpt', entity_name='s00_ep01_sq100_sh100', entity='Shot')
    #update_usd_assemblies('tpt', entity_name='Environment_Neutral', entity='Asset')
    #update_usd_assemblies('tpt', entity='Shot')