
import ast
import os

import shotgun_api3
import yaml

import add_file_to_asset as add_asset

server = 'https://tds.shotgunstudio.com'
script_name = 'Interface'
api_key = 'dxfvstbke8zfzLmoacdlno@va'

config_file = r'C:\ProgramData\pipeline\taskbrowser_migration\databased\usd\poc\config\asset_usd_scheme.yaml'
with open(config_file, 'r') as y_file:
    config_data = yaml.safe_load(y_file)


root_path = 'V:/SGD/publish/usd/assets'
if not os.path.exists(root_path):
    os.makedirs(root_path)
os.chdir(root_path)

default_config = config_data['default']
layers = config_data['layers']

sg_connection = shotgun_api3.Shotgun(server, script_name=script_name, api_key=api_key)

filters = [['project.Project.code', 'is', 'SGD'],
           ['sg_delete', 'is', False],
           ['sg_complete', 'is', True],
           ]
scheme = sg_connection.schema_field_read('CustomEntity09')
fields = ['code', 'sg_task', 'sg_variant', 'sg_version_number', 'sg_files', 'sg_publish_type', 'sg_asset',
          'sg_published_folder']

publish_data = sg_connection.find('CustomEntity09', filters=filters, fields=fields)

assembly_created = []
for layer_data in layers:
    for layer_type, layer_data in layer_data.items():
        layer_config = default_config.copy()
        for key, value in layer_data.items():
            layer_config[key] = value

    for sg_item in publish_data:
        publish_type = sg_item['sg_publish_type'].get('name')
        asset_name = sg_item['sg_asset'].get('name')
        variant = sg_item['sg_variant'].get('name')
        version = '%03d' % sg_item['sg_version_number']
        files = ast.literal_eval(sg_item['sg_files'])
        folder = sg_item['sg_published_folder']
        relative_path = files.get(layer_config.get('file_label', ))
        if relative_path:
            full_path = os.path.join(folder, relative_path)

            add_asset.add_file_to_asset(asset_name, layer_type, variant, full_path, version)




