from pprint import pprint
import mayaUsd
from maya import cmds
from pxr import Usd, UsdGeom, UsdShade, Sdf


def create_shader(shape):

    stage = mayaUsd.ufe.getStage(shape)

    mtl_prim = stage.GetPrimAtPath('/geometry/mtl')

    mtl_path = Sdf.Path('/geometry/mtl/metal_mat')

    mtl = UsdShade.Material.Define(stage, mtl_path)

    shader = UsdShade.Shader.Define(stage, mtl_path.AppendPath("Shader"))
    mtl.CreateSurfaceOutput().ConnectToSource(shader.ConnectableAPI(), "surface")



    source_prim = stage.GetPrimAtPath(source_path)

    attr = source_prim.GetAttribute("outputs:arnold:surface")

    print(attr.IsDefined())
    value = attr.GetConnections()
    print(value)

    arnold_mat_prim = stage.GetPrimAtPath(value[0].GetPrimPath())

    for attr in arnold_mat_prim.GetAttributes():
        connections = attr.GetConnections()
        if connections:
            print(attr, connections)

    mtl_prim = stage.GetPrimAtPath('/%s/mtl' % asset_name)

    mtl_path = Sdf.Path('/%s/mtl/metal_mat' % asset_name)
    mtl = UsdShade.Material.Define(stage, mtl_path)

    shader = UsdShade.Shader.Define(stage, mtl_path.AppendPath("Shader"))
    mtl.CreateSurfaceOutput().ConnectToSource(shader.ConnectableAPI(), "surface")
