import os

import importlib
from pxr import Usd, UsdShade

import usd.lib.usd_asset as usd_asset

import usd.lib.reparent_prim as reparent_prim

import actions.maya.shading.create_preview_shader as create_preview_shader

importlib.reload(usd_asset)
importlib.reload(reparent_prim)
importlib.reload(create_preview_shader)

cleaner_scene = {
    'shading': {'node_types': ['Material', 'Shader'], 'attributes': ['material:binding', 'primvars:displayColor']},
    'uv': {'node_types': ['Material', 'Shader'], 'attributes': ['primvars:st', 'primvars:st:indices']},
    'setedit': {'node_types': ['Xform'], 'attributes': ['xformOp:rotateXYZ', 'xformOp:scale', 'xformOp:translate', 'active']},

}




def clean_file(path, remove_str, asset_root):
    import shutil
    tmp_file = '%s/clean_usd.usda' % os.environ['TMP']
    shutil.copy2(path, tmp_file)
    source_file = open(tmp_file, 'r')
    target_file = open(path, 'w')

    for line in source_file.readlines():
        clean_line = line.replace(remove_str, '')
        clean_line = clean_line.replace('"%s"' % asset_root, '"asset"')
        target_file.write(clean_line)

    source_file.close()
    target_file.close()


def clean_usd_scene(source_path, output_path=None, config='shading', flatten_meshes=False, move_mtl=False):
    node_types = cleaner_scene[config]['node_types']
    attributes = cleaner_scene[config]['attributes']
    stage = Usd.Stage.Open(source_path)
    stage_layer = stage.GetRootLayer()

    default_prim = stage.GetDefaultPrim()
    default_prim_path = default_prim.GetPath()

    if move_mtl:
        reparent_prim.reparent_prim(stage_layer, '/mtl', '%s/mtl' % str(default_prim_path))

    to_delete = []
    for prim in stage.TraverseAll():

        prim_type = prim.GetTypeName()
        parent_prim = prim.GetParent()
        if str(prim.GetPath()).find('body') > -1:
            print('this:', prim.GetPath())
            print('parent:', parent_prim.GetPath())
        if prim_type in node_types:
            continue

        for prim_property in prim.GetAuthoredProperties():

            property_name = prim_property.GetName()
            if property_name not in attributes:
                if prim.GetTypeName() == 'GeomSubset':
                    pass

                else:
                    prim.RemoveProperty(prim_property.GetName())

            elif flatten_meshes and prim_type == 'Mesh':

                if property_name == 'material:binding':
                    parent_prim.SetTypeName("Mesh")
                    print('flatten', parent_prim.GetPath())
                    mat_bind_api = UsdShade.MaterialBindingAPI.Apply(parent_prim)
                    to_delete.append(prim)

                    target = prim_property.GetTargets()[0]
                    print('material:binding', target)
                    material_prim = stage.GetPrimAtPath(target)
                    material = UsdShade.Material(material_prim)
                    mat_bind_api.Bind(material)
                    print(material)

                
        prim.SetTypeName('Over')
        mtl_prim = stage.GetPrimAtPath('%s/mtl' % str(default_prim_path))
        mtl_prim.SetTypeName('Scope')



    for prim in to_delete:
        stage.RemovePrim(prim.GetPath())

    create_preview_shader.create_preview_from(stage)

    stage.GetRootLayer().Save()

def export_shading(output_path, asset_name, version, variant):
    print('export shading')
    import maya.cmds as cmds
    asset_node = None
    for node in cmds.ls(type='UsdAssembly'):
        if cmds.getAttr('%s.assetName' % node) == asset_name:
            asset_node = node

    print('asset_node', asset_node)

    if asset_node is None:
        return
    cmds.select(asset_node, r=True)

    asset_namespace = cmds.getAttr('%s.representationNamespace' % asset_node)

    cmds.arnoldExportAss(f=output_path, mask=24, s=True, exportAllShadingGroups=True)#, exportPrefix=prefix)
    clean_file(output_path, '%s_' % asset_namespace, asset_node)

    clean_usd_scene(output_path, config='shading', flatten_meshes=True, move_mtl=True)


    return {'usd': output_path}


if __name__ == '__main__':
    asset = 'cube'
    import add_file_to_asset as add_file_to_asset

    importlib.reload(add_file_to_asset)

    geometry_path = 'D:/Documentos/maya/projects/default/scenes/cube.usda'
    usd_path = 'D:/Documentos/maya/projects/default/scenes/basic_cube_usd.usda'
    asset_name = 'cube'
    spherical_path = 'D:/Documentos/maya/projects/default/scenes/cube_uv_spherical.usda'
    output_uv_path = 'D:/Documentos/maya/projects/default/scenes/cube_spherical.usda'
    clean_usd_scene(spherical_path, config='uv', output_path=output_uv_path)

    output_path = 'D:/Documentos/maya/projects/default/scenes/cube_shading.usda'

    paths = export_shading(usd_path, output_path, asset_name)

    layer_type = 'geometry'
    variant = 'Master'
    version = 1
    add_file_to_asset.add_file_to_asset(asset, layer_type, variant, geometry_path, version)

    layer_type = 'shading'
    add_file_to_asset.add_file_to_asset(asset, layer_type, variant, paths['shading'], version)

    layer_type = 'uvs'
    add_file_to_asset.add_file_to_asset(asset, layer_type, variant, paths['uv'], version)

    variant = 'Spherical'
    add_file_to_asset.add_file_to_asset(asset, layer_type, variant, output_uv_path, 2)





