import os.path
from pprint import pprint

import shotgrid_lib.database as database
def merge_layers(project, publish_id, output_path, file_tags, entity_name, entity_type, asset_type=None):
    import usd.lib.usd_manager as usd_manager
    print('project', project)
    print('publish_id', publish_id)
    print('output_path', output_path)
    file_tags = file_tags[0].split(' ')
    print('file_tags', file_tags)
    print('entity_name', entity_name)
    print('entity_type', entity_type)

    folder = os.path.dirname(output_path)
    if not os.path.exists(folder):
        os.makedirs(folder)
    sg_database = database.DataBase()
    sg_database.fill(project, precatch=False)

    filters = [['id', 'is', publish_id]]
    sg_database.query_sg_database('CustomEntity09', filters=filters, as_precache=False)

    current_publish = sg_database['CustomEntity09'].find_with_filters(id=publish_id, single_item=True)
    pprint(current_publish.sg_files)

    manager = usd_manager.UsdManager(project)

    manager.set_entity(entity_name, entity_type, asset_type=asset_type)
    manager.open(output_path)
    manager.stage.SetMetadata('timeCodesPerSecond', 24)

    default_prim = manager.stage.DefinePrim('/World')
    manager.default_prim = '/World'

    for layer_tag in file_tags:
        relative_path = current_publish.sg_files.get(layer_tag)
        if not relative_path:
            continue
        path = '%s/%s' % (current_publish.sg_published_folder, relative_path)
        manager.add_sublayer(path)

    manager.print()
    manager.save_stage()

if __name__ == '__main__':
    import argparse

    parser = argparse.ArgumentParser(description='Shotgun event launcher')
    parser.add_argument('-o', '-output', '--output-path', dest='output_path', help='Output usd path')

    parser.add_argument('-p', '-project', '--project', dest='project', help='project')

    parser.add_argument('-n', '-name', '--entity-name', dest='entity_name', help='Entity name')
    parser.add_argument('-t', '-type', '--entity-type', dest='entity_type', help='Entity type')
    parser.add_argument('-at', '-asset', '--asset-type', dest='asset_type', help='Asset type')

    parser.add_argument('-id', '-shotgrid-id', '--shotgrid-id', dest='shotgrid_id', type=int,
                        help='shotgrid id of the publish')


    parser.add_argument('-l', '-layers', '--layers', dest='layers', default=['usd_camera', 'usd_cache', 'set_edit'],
                        nargs='+', help='List of layers')

    args = parser.parse_args()

    project = 'TPT'
    shotgrid_id = 931
    layers = ['usd_camera', 'usd_cache', 'set_edit']
    output_path = 'C:/Users/fernando.vizoso/Documents/maya/projects/default/data/merged_layers_layout.usda'

    if args.entity_type == 'Shot':
        merge_layers(args.project,
                     args.shotgrid_id,
                     args.output_path,
                     args.layers,
                     args.entity_name,
                     args.entity_type)
    else:
        merge_layers(args.project,
                     args.shotgrid_id,
                     args.output_path,
                     args.layers,
                     args.entity_name,
                     args.entity_type,
                     asset_type=args.asset_type)

