import importlib

import shotgrid_lib.database as database


def update_usd_assemblies(project, entity_name=None, entity='Asset'):
    import usd.lib.usd_manager as usd_manager
    importlib.reload(usd_manager)

    sg_database = database.DataBase()
    sg_database.fill(project, precatch=False)
    sg_database.query_sg_database(entity)

    for asset_view in sg_database[entity]:
        if entity_name is not None and asset_view.code != entity_name:
            continue

        if entity == 'Asset':
            print(asset_view.code, asset_view.sg_asset_type)
            asset_type = asset_view.sg_asset_type.replace(' ', '_')
        else:
            print(asset_view.code)
            asset_type = None
        manager = usd_manager.UsdManager(project)

        manager.set_entity(asset_view.code, entity, asset_type=asset_type)
        filename = manager.filename
        manager.open(filename)

        manager.create_entity_assembly()
        asset_view.precache_dependencies(fields=['sg_published_elements'])

        for publish in asset_view.sg_published_elements:
            if publish.sg_delete or not publish.sg_complete:
                continue
            if 'usd' not in publish.sg_files:
                continue
            step = publish.sg_step_name
            variant = publish.sg_variant_name
            version = publish.sg_version_number
            version_path = '%s/%s' % (publish.sg_published_folder, publish.sg_files['usd'])
            manager.add_asset_version(step, variant, version, version_path)



if __name__ == '__main__':
    #update_usd_assemblies('tpt', entity_name='Tentacle',entity='Asset')
    #update_usd_assemblies('tpt', entity='Asset')
    update_usd_assemblies('tpt', entity_name='s00_ep01_sq100_sh100', entity='Shot')
    #update_usd_assemblies('tpt', entity_name='Environment_Neutral', entity='Asset')
    #update_usd_assemblies('tpt', entity='Shot')