import os
import getpass
import importlib
import logging

from pprint import pprint

from Deadline.DeadlineConnect import DeadlineCon as Connect
import library.core.config_manager as config_manager
import library.core.references_solver as references_solver

importlib.reload(config_manager)
logger = logging.getLogger(__name__)


def init_connection(config_mng):

    deadline_settings = config_mng.get_config('repository', module='deadline_lib')
    deadlineConnection = Connect(deadline_settings['server_url'], deadline_settings['server_port'] )

    deadlineConnection.EnableAuthentication( True )
    deadlineConnection.SetAuthenticationCredentials(username = deadline_settings['user_name'],
                                                    password = deadline_settings['password'],
                                                    enable=True )
    return deadlineConnection


def launch_postanim_job(project, animation_id):

    job_options = {}
    config_mng = config_manager.ConfigSolver(project=project)
    deadline_connection = init_connection(config_mng)


    job_name = 'Launch_postanim_id_%s' % animation_id

    batch_name = 'postanim_callback_launcher'
    pool = 'trf-workers'
    python_path = 'PYTHONPATH=%s;%s/python/3.10/Lib/site-packages;%s/python/3.10/Scripts;'

    project_config = config_mng.project_config
    company_config = config_mng.company_config
    pprint(company_config)
    job_options.update({'Plugin': 'AACommandLine',
                        "Name": job_name,
                        "BatchName": batch_name,
                        "Pool": pool,
                        "Group": "on",
                        "Priority": 100,
                        'EnvironmentKeyValue0': python_path % (company_config['root'],
                                                               company_config['root'],
                                                               company_config['root']
                                                               ),
                        'EnvironmentKeyValue1': 'COMPANY_ROOT=%s' % company_config['company_root'],
                        'EnvironmentKeyValue2': 'LAUNCHER_VERSION=%s' % os.environ.get('LAUNCHER_VERSION', '1.0.0'),
                        'EnvironmentKeyValue3': 'LIBRARY_VERSION=%s' % os.environ.get('LIBRARY_VERSION', '0.1.0'),
                        'EnvironmentKeyValue1': 'TOOOLS_ROOT=%s' % company_config['tools_root'],
                        'UserName': getpass.getuser(),
                        'frames': '1'
                        })

    executable = '%s/usd/1.0.0/scripts/launch_update_asset_job.py' % company_config['tools_root']
    arguments = '--project %s --shotgrid-id %s' % (project, animation_id)
    plugin_options = {'Executable': str(executable),
                      'Arguments': arguments,
                      'Project': project,
                      'Standalone': 'python',
                      'Pool': pool}

    pprint(job_options)
    pprint(plugin_options)

    new_job = deadline_connection.Jobs.SubmitJob(job_options, plugin_options)
    print('=' * 100)
    print(new_job)

if __name__ == '__main__':
    launch_postanim_job('TPT', 1077)


