import os

import maya.cmds as cmds
from pxr import Usd, UsdGeom, Sdf, Kind

import shotgrid_lib.database as database

alembic_path = 'C:/Users/fernando.vizoso/Documents/maya/projects/maya/cache/alembic/leo_test.abc'


def add_attribute(prim, attribute, value=None, attr_type=Sdf.ValueTypeNames.String):
    new_attr = prim.CreateAttribute(attribute, attr_type)
    if value:
        new_attr.Set(value)
    return new_attr


def export_children(stage, maya_root, usd_root):
    sg_database = database.DataBase()
    project = os.environ['PROJECT']
    sg_database.fill(project)

    usd_root_path = usd_root.GetPath()
    children = cmds.listRelatives(maya_root, c=True, f=False)
    child_ids = []
    for child in children:
        if cmds.nodeType(child) == 'Assembly':
            shotgrid_id = cmds.getAttr('%s.shotgrid_id' % child)
            shotgrid_id = int(shotgrid_id.split(':')[-1])
            child_ids.append(shotgrid_id)

    sg_database.query_entity('CustomEntity09', filters=['id', 'in', child_ids])

    print('maya root', maya_root)
    print('usd_root', usd_root.GetPath())
    for child in children:
        print(child)
        full_path = '%s/%s' % (usd_root_path, child)
        print('path', full_path)

        if cmds.nodeType(child) == 'transform':
            child_prim = stage.DefinePrim(full_path, 'Xform')
            transformable = UsdGeom.Xformable(child_prim)
            translate = cmds.getAttr('%s.translate' % child)[0]
            rotate = cmds.getAttr('%s.translate' % child)[0]
            scale = cmds.getAttr('%s.scale' % child)[0]
            print(translate)
            transformable.AddTranslateOp().Set(value=(translate[0], translate[1], translate[2]))
            transformable.AddRotateXYZOp().Set(value=(rotate[0], rotate[1], rotate[2]))
            transformable.AddScaleOp().Set(value=(1.0, 1.0, 1.0))

            export_children(stage, child, child_prim)
            model_API = Usd.ModelAPI(child_prim)
            model_API.SetKind(Kind.Tokens.group)

        elif cmds.nodeType(child) == 'Assembly':
            alembic_path = cmds.getAttr('%s.path' % child)

            child_prim = stage.DefinePrim(full_path, 'Xform')
            assembly_attr = add_attribute(child_prim, 'assembly_type', value='Geometry')
            shotgrid_id_attr = add_attribute(child_prim, 'shotgrid_id')
            path_attr = add_attribute(child_prim, 'path')
            asset_name_attr = add_attribute(child_prim, 'asset_name')
            variant_attr = add_attribute(child_prim, 'variant')
            version_attr = add_attribute(child_prim, 'version')

            shading_variant_attr = add_attribute(child_prim, 'shading_variant')
            shading_version_attr = add_attribute(child_prim, 'shading_version')

            transformable = UsdGeom.Xformable(child_prim)

            transformable.AddTranslateOp()
            transformable.AddRotateXYZOp()
            transformable.AddScaleOp().Set(value=(.01, .01, .01))

            payloads = child_prim.GetPayloads()
            payloads.ClearPayloads()
            shotgrid_id = cmds.getAttr('%s.shotgrid_id' % child)
            shotgrid_id = int(shotgrid_id.split(':')[-1])

            this_publish sg_database.get_index_from_table('CustomEntity09', shotgrid_id, unique=True)

            path =
            payloads.AddPayload(alembic_path)

            model_API = Usd.ModelAPI(child_prim)
            model_API.SetKind(Kind.Tokens.assembly)


def export_usd(filename, asset_name, root):
    stage = Usd.Stage.CreateNew(filename)
    asset_prim = stage.DefinePrim('/%s' % asset_name, 'Xform')
    stage.SetDefaultPrim(asset_prim)

    export_children(stage, root, asset_prim)

    print(stage.GetRootLayer().ExportToString())

    stage.GetRootLayer().Save()

if __name__ == '__main__':

    path = r'C:\Users\fernando.vizoso\Documents\maya\projects\data/test.usda'
    if os.path.exists(path):
        os.remove(path)

    asset_name = 'set'
    root = 'group3'

    export_usd(path, asset_name, root)