import importlib

from PySide import QtWidgets, QtCore

import packages_io

import library.ui.labeled as labeled_widgets

import usd.lib.ui.prim_attribute as prim_attribute
import usd.lib.usd_manager as usd_manager

importlib.reload(prim_attribute)


class PrimAttributeEditor(QtWidgets.QWidget):
    def __init__(self, manager=None, parent=None):
        super(PrimAttributeEditor, self).__init__(parent=parent)
        self.manager = manager
        self.attribute_widgets = {}

        self.stage = self.manager.stage
        self.main_layout = QtWidgets.QVBoxLayout()

        self.prim_name_widget = labeled_widgets.LabeledText('', 'Prim' )
        self.prim_path_widget = labeled_widgets.LabeledText('', 'Path')

        self.main_layout.addWidget(self.prim_name_widget)
        self.main_layout.addWidget(self.prim_path_widget)

        self.attributes_layout = QtWidgets.QVBoxLayout()
        self.main_layout.addLayout(self.attributes_layout)

        self.setLayout(self.main_layout)
        self.main_layout.addStretch(1)
        self.main_layout.setContentsMargins(0, 0, 0, 0)


    def update_prin(self, prim):
        self.prim = prim
        self.prim_path = prim.GetPath().pathString
        self.prim_name = prim.GetName()
        self.prim_type = prim.GetTypeName()

        self.prim_name_widget.setValue('%s - %s' % (self.prim_name, self.prim_type))
        self.prim_path_widget.setValue(self.prim_path)
        attribute_list = {}

        for attribute_name, attribute_widget in self.attribute_widgets.items():
            attribute_widget.deleteLater()

        self.attribute_widgets = {}


        for attribute in prim.GetAttributes():

            name = attribute.GetName()
            value = attribute.Get()
            attr_type = attribute.GetTypeName()
            print(name, value, attr_type)
            if attr_type == 'token':
                attribute_widget = labeled_widgets.LabeledText(value, name, editable=True)
            elif attr_type == 'uchar':
                attribute_widget = labeled_widgets.LabeledInt(value, name)
            elif attr_type == 'bool':
                if value:
                    value = True
                else:
                    value = False
                attribute_widget = labeled_widgets.LabeledBoolean(value, name)
            else:
                continue

            self.attributes_layout.addWidget(attribute_widget)
            self.attribute_widgets[name] = attribute_widget


class StageManagerWidget(QtWidgets.QWidget):
    def __init__(self, project=None, maya_node=None, usd_path=None, parent=None):
        super(StageManagerWidget, self).__init__(parent=parent)
        self.project = project
        self.usd_path = usd_path
        self.maya_node = maya_node

        self.setObjectName('Light linker')
        self.main_layout = QtWidgets.QVBoxLayout()

        self.manager_layout = QtWidgets.QHBoxLayout()
        self.main_layout.addLayout(self.manager_layout)
        self.manager = usd_manager.UsdManager(self.project)

        if self.usd_path:
            self.manager.open(self.usd_path)
        elif self.maya_node:
            self.manager.get_stage_from_maya(self.maya_node)
        else:
            return

        self.stage_tree = prim_attribute.UsdStageTree(self.project,
                                                      parent=self,
                                                      manager=self.manager)
        self.stage_tree.selected_prim.connect(self.set_prim)

        self.manager_layout.addWidget(self.stage_tree)

        self.attribute_widget = PrimAttributeEditor(manager=self.manager)

        self.manager_layout.addWidget(self.attribute_widget)

        self.setLayout(self.main_layout)
        self.main_layout.setContentsMargins(0, 0, 0, 0)


    def set_prim(self, item):
        prim = item.prim

        print(prim)
        self.attribute_widget.update_prin(prim)
class StageManagerWindow(packages_io.MainWindow):
    def __init__( self, project, maya_node=None, usd_path=None):
        super(StageManagerWindow, self ).__init__('Light linker')
        self.project = project
        self.setContentsMargins(0,0, 0,0)
        self.main_widget = StageManagerWidget(project=project, maya_node=maya_node, usd_path=usd_path, parent=self)
        self.setMinimumSize(500, 800)
        self.setCentralWidget(self.main_widget)

        self.apply_style(self)
