import importlib

from PySide import QtWidgets, QtCore

import packages_io

import usd.lib.ui.prim_attribute as prim_attribute
import usd.lib.usd_manager as usd_manager


importlib.reload(prim_attribute)


class LightLinkWidget(QtWidgets.QWidget):
    def __init__(self, project=None, maya_node=None, usd_path=None, parent=None):
        super(LightLinkWidget, self).__init__(parent=parent)
        self.project = project
        self.usd_path = usd_path
        self.maya_node = maya_node

        self.setObjectName('Light linker')
        self.main_layout = QtWidgets.QVBoxLayout()

        self.trees_layout = QtWidgets.QHBoxLayout()
        self.main_layout.addLayout(self.trees_layout)
        self.manager = usd_manager.UsdManager(self.project)

        if self.usd_path:
            self.manager.open(self.usd_path)
        elif self.maya_node:
            self.manager.get_stage_from_maya(self.maya_node)
        else:
            return

        self.light_tree = prim_attribute.UsdStageTree(self.project,
                                                      prim_type='light',
                                                      parent=self,
                                                      manager=self.manager)

        self.trees_layout.addWidget(self.light_tree)

        self.light_tree.selected_prim.connect(self.select_light)
        self.node_tree = prim_attribute.UsdStageTree(self.project,
                                                      prim_type='geometry',
                                                      parent=self,
                                                      manager=self.manager,
                                                      checkable=True)

        self.trees_layout.addWidget(self.node_tree)
        self.node_tree.setSelectionMode(self.node_tree.selectionMode().MultiSelection)

        #self.node_tree.selected_prim.connect(self.apply_light_link)

        self.setLayout(self.main_layout)
        self.main_layout.setContentsMargins(0, 0, 0, 0)

    def apply_light_link(self, item):
        prim = item.prim
        #lights = self.get_selected_children(self.light_tree)

        print(item.text(), item.checkState())
        #for light in lights:


    def select_light(self, item):
        prim = item.prim
        assigned_geo = []
        light_path = prim.GetPath().pathString
        for prim in self.manager.stage.Traverse():
            attribute = self.manager.get_attribute(prim, 'primvars:arnold:light_group')
            if attribute and attribute.IsValid():
                lights = attribute.Get()
                if light_path in lights:
                    assigned_geo.append(prim)
            else:
                assigned_geo.append(prim)
        print(prim)
        self.node_tree.select_prims(assigned_geo)

class LightLinkWindow(packages_io.MainWindow):
    def __init__( self, project, maya_node=None, usd_path=None):
        super(LightLinkWindow, self ).__init__('Light linker')
        self.project = project
        self.setContentsMargins(0,0, 0,0)
        self.main_widget = LightLinkWidget(project=project, maya_node=maya_node, usd_path=usd_path, parent=self)
        self.setMinimumSize(500, 800)
        self.setCentralWidget(self.main_widget)

        self.apply_style(self)
