import os

import maya.cmds as cmds


def create_assembly(alembic_path, shader_path=None, assembly_name='geo', assembly_type='Geometry'):

    cmds.loadPlugin('geometry_assembly.py' )

    geo_node = cmds.createNode('GeometryAssembly', name=assembly_name)

    cmds.setAttr('%s.geometryPath' % geo_node, alembic_path, type='string')

    if shader_path and os.path.exists(shader_path):
        print('assigning shaders')
        cmds.setAttr('%s.shadingPath' % geo_node, shader_path, type='string')
    return geo_node

def create_camera(geo_node, cam_y=.85, frames=48):
    camera_node = cmds.createNode('camera', n='tt_cameraShape')
    print(camera_node)

    parent_node = cmds.listRelatives(camera_node, p=True)
    cmds.rename(parent_node, 'tt_camera')

    cmds.createNode('transform', n='tt_cam_group')
    cmds.parent('tt_camera', 'tt_cam_group')

    cmds.select(geo_node, r=True)
    cmds.viewFit('tt_camera', f=cam_y)

    cmds.currentTime(101)

    cmds.setKeyframe('tt_cam_group', v=0, attribute='rotateY', ott='linear')
    cmds.currentTime(101 + frames)
    cmds.setKeyframe('tt_cam_group', v=360, attribute='rotateY', ott='linear')


    sphere_grey = cmds.polySphere()
    sphere_reflections = cmds.polySphere()
    macbeth_chart = cmds.polyPlane()

    cmds.parent(sphere_grey, camera_node)
    cmds.parent(sphere_reflections, camera_node)
    cmds.parent(macbeth_chart, camera_node)

    cmds.setAttr('%s.translate' % sphere_grey[0], .58, -.38, -1.5, type='double3')
    cmds.setAttr('%s.scale' % sphere_grey[0], .03, .03, .03, type='double3')
    cmds.sets(sphere_grey, e=True, forceElement='grey_shader_sg')

    cmds.setAttr('%s.translate' % sphere_reflections[0], .5, -.38, -1.5, type='double3')
    cmds.setAttr('%s.scale' % sphere_reflections[0], .03, .03, .03, type='double3')
    cmds.sets(sphere_reflections, e=True, forceElement='reflexion_shader_sg')

    cmds.setAttr('%s.translate' % macbeth_chart[0], .7, -.38, -1.5, type='double3')
    cmds.setAttr('%s.rotate' % macbeth_chart[0], 90, 0, 0, type='double3')

    cmds.setAttr('%s.scale' % macbeth_chart[0], .12, .1, .08, type='double3')
    cmds.sets(macbeth_chart, e=True, forceElement='macbeth_shader_sg')


def create_lights():
    cmds.shadingNode('RedshiftDomeLight', asLight=True)


def set_render_settings(frames, output_path):
    folder = os.path.dirname(output_path)
    basename = os.path.basename(output_path)
    name = basename.split('.')[0]
    output_images = '%s/%s' % (folder, name)
    cmds.setAttr("defaultRenderGlobals.currentRenderer", "redshift", type="string")
    cmds.setAttr("defaultRenderGlobals.animation", 1)
    cmds.setAttr("defaultRenderGlobals.startFrame", 101)
    cmds.setAttr("defaultRenderGlobals.endFrame", 100 + frames)
    cmds.setAttr('defaultRenderGlobals.imageFilePrefix', output_images, type='string')

    cmds.setAttr("perspShape.renderable", 0)

    #cmds.setAttr("redshiftOptions.imageFormat", 2)

    cmds.setAttr('defaultResolution.width', 1920)
    cmds.setAttr('defaultResolution.height', 1080)




if __name__ == '__main__':

    alembic_path = r'C:\Users\fernando.vizoso\tempFile\03_dtb\model\LeoMesi\ModelingHD\LeoMesi_Master_c769222592954141\v013\abc\LeoMesi.abc'
    output_path = r'C:\Users\fernando.vizoso\tempFile\03_dtb\model\LeoMesi\ModelingHD\LeoMesi_Master_c769222592954141\v013\turntable\tt_scene.mb'

    create_turntable(alembic_path, output_path)

