import os
import shutil
import glob
import maya.cmds as cmds

texture_node_types = {'file': 'fileTextureName', 'aiImage': 'filename'}


def copy_texture(server_path, local_root):
    server_path = server_path.replace('\\', '/')
    source_folder = os.path.dirname(server_path)
    bits = server_path.split('/')
    
    texture_set_name = bits[-1].split('_')[0]
    texture_set_mask = bits[-2]

    new_folder = '%s/sourceimages/%s/%s' % (local_root, texture_set_name,texture_set_mask)
    
    if not os.path.exists(new_folder):
        os.makedirs(new_folder)

    for texture_file in os.listdir(source_folder):
        if texture_file[0] == '.':
            continue
        full_source_path = '%s/%s' % (source_folder, texture_file)
        full_new_path = '%s/%s' % (new_folder, texture_file)

        print('Copyng texture: {texture_set_name}, to: {full_new_path}')
        shutil.copy2(full_source_path, full_new_path)

    full_new_texture = '%s/%s' % (new_folder, bits[-1])

    return full_new_texture

def localize_textures():
    print('== Initiate Texture Localization ==')
    
    local_root = cmds.workspace(act=True, q=True)
    for node_type, attribute in texture_node_types.items():
        all_nodes = cmds.ls(type=node_type)
        for texture_node in all_nodes:
            print(f"Working on node: {texture_node}")

            current_path = cmds.getAttr('%s.%s' % (texture_node, attribute))

            if not cmds.attributeQuery('path', n=texture_node, exists=True):
                local_path = copy_texture(current_path, local_root)
            else:
                local_path = cmds.getAttr('%s.path' % texture_node).replace('<UDIM>', '*')
                local_paths = glob.glob(local_path)
                if local_paths:
                    local_path = local_paths[0]
                else:
                    local_path = None

                if not local_path or not os.path.exists(local_path):
                    print('Cant find local texture, copying')
                    local_path = copy_texture(current_path, local_root)

                elif local_path.lower().startswith('v:'):
                    local_path = copy_texture(current_path, local_root)

            colorspace = cmds.getAttr('%s.colorSpace' % texture_node)

            if not current_path.lower().startswith('\\\\project'):
                continue

            cmds.setAttr('%s.%s' % (texture_node, attribute), local_path, type='string')
            cmds.setAttr('%s.uvTilingMode' % texture_node, 3)
            cmds.setAttr('%s.colorSpace' % texture_node, colorspace, type='string')

            print(f"Texture path: {current_path} updated to: {local_path}")