import os
import importlib
import shotgrid_lib.lib.shotgrid_functions as shotgrid_functions
import library.sandbox as sandbox

import packages_io
importlib.reload(shotgrid_functions)


def open_latest_version(task=None, sandbox_folder='maya/scenes', project='sgd', save_locally=False):
    entity = task.entity
    pipeline_step = task.step_name
    variant = task.sg_variant_name

    published_path = shotgrid_functions.get_source_scene(entity, pipeline_step, variant)

    packages_io.file_open(published_path)
    sandbox_solver = sandbox.Sandbox(project=project)
    if entity.type == 'Asset':
        sandbox_solver.set_context(asset_name=entity.code, asset_type=entity.sg_asset_type)
    else:
        sandbox_solver.set_context(shot_name=entity.code)

    sandbox_path = sandbox_solver.build()

    if not save_locally:
        return
    sandbox_solver.content = pipeline_step
    sandbox_solver.variant = variant
    sandbox_solver.extension = 'ma'

    filename = sandbox_solver.generate_filename()
    sandbox_solver.generate_path()
    full_path = os.path.join(sandbox_path, sandbox_folder, filename)
    full_version_path = sandbox.get_version_path(full_path)

    packages_io.file_save(rename_to=full_version_path)


if __name__ == '__main__':
    import shotgrid_lib.database as database

    #importlib.reload(database)

    sg_database = database.DataBase()
    sg_database.fill('sgd')

    sg_database.query_sg_database('Asset', as_precache=True)

    item = sg_database['Asset']['LeoMesi']
    full_path = open_latest_version(item, 'Model', 'Low')
    print(full_path)