import os
import requests
import importlib

import task_manager.lib.helpers as helpers
import shotgrid_lib.database as database

import library.ui.labeled as labeled

from PySide import QtCore, QtGui, QtWidgets

importlib.reload(helpers)
importlib.reload(labeled)

extra = {'title': '#dc3545'}




class ToolsWidget(QtWidgets.QFrame):
    arrange = 'vertical'
    font_style_sheet = "color: rgb(210,210,210);"

    def __init__(self, pipeline_step, parent=None):
        super(ToolsWidget, self).__init__(parent=parent)
        self.setSizePolicy(QtWidgets.QSizePolicy.MinimumExpanding, QtWidgets.QSizePolicy.MinimumExpanding)

        self.pipeline_step = pipeline_step

        self.layout = QtWidgets.QVBoxLayout()

        self.layout.setSpacing(8)
        self.layout.setContentsMargins(2, 2, 2, 2)

        self.label_widget = QtWidgets.QLabel('%s:' % self.pipeline_step)
        self.label_widget.setFixedWidth(115)
        self.label_widget.setAlignment(QtCore.Qt.AlignRight | QtCore.Qt.AlignVCenter)

        self.setLayout(self.layout)

        self.layout.addWidget(self.label_widget)


class LabeledWidget(QtWidgets.QFrame):
    arrange = 'vertical'
    font_style_sheet = "color: rgb(210,210,210);"

    def __init__(self, value, label, parent=None, values=None):
        super(LabeledWidget, self).__init__(parent=parent)
        self.setSizePolicy(QtWidgets.QSizePolicy.MinimumExpanding, QtWidgets.QSizePolicy.MinimumExpanding)

        self.label = label
        self.value = value
        if values is None:
            self.values = []
        else:
            self.values = values

        if self.arrange == 'vertical':
            self.layout = QtWidgets.QVBoxLayout()
        else:
            self.layout = QtWidgets.QHBoxLayout()

        self.layout.setSpacing(8)
        self.layout.setContentsMargins(2, 2, 2, 2)

        self.label_widget = QtWidgets.QLabel('%s:' % self.label.title())
        self.label_widget.setFixedWidth(115)
        self.label_widget.setAlignment(QtCore.Qt.AlignRight | QtCore.Qt.AlignVCenter)

        self.setLayout(self.layout)

        self.layout.addWidget(self.label_widget)


class TitleLabel(QtWidgets.QLabel):
    pass


class TitleWidget(QtWidgets.QFrame):
    arrange = 'horizontal'

    def __init__(self, value, label, parent=None):
        super(TitleWidget, self).__init__(parent=parent)
        self.setSizePolicy(QtWidgets.QSizePolicy.MinimumExpanding, QtWidgets.QSizePolicy.MinimumExpanding)

        self.label = label
        self.value = value

        self.layout = QtWidgets.QVBoxLayout()
        self.layout.setSpacing(2)
        self.layout.setContentsMargins(0, 0, 0, 0)
        title = '%s - %s' % (self.label.title(), self.value.title())
        self.label_widget = TitleLabel(title)
        self.label_widget.setAlignment(QtCore.Qt.AlignHCenter | QtCore.Qt.AlignVCenter)
        self.setLayout(self.layout)

        self.layout.addWidget(self.label_widget)


class ThumbnailWidget_(QtWidgets.QFrame):
    clicked = QtCore.Signal()

    def __init__(self, value, label, parent=None):
        super(ThumbnailWidget_, self).__init__(parent=parent)
        self.card = parent
        self.value = value

        self.visible = False

        self.setFixedHeight(90)
        self.setFixedWidth(130)
        self.layout = QtWidgets.QVBoxLayout()
        self.layout.setSpacing(2)
        self.layout.setContentsMargins(10, 0, 10, 0)

        self.button = QtWidgets.QPushButton(self)
        self.button.setFixedSize(120, 80)

        self.layout.addWidget(self.button)
        self.setLayout(self.layout)
        self.button.clicked.connect(self.launch_task)

        self.update_widgets = helpers.SubClassThread(self)
        self.update_widgets.start()

    def background(self):
        self.update()

    def update(self):
        thumbnail_path = self.value.image
        if thumbnail_path is None or thumbnail_path == 'None' or isinstance(thumbnail_path, database.emptyView):
            return
        image = QtGui.QImage()
        image.loadFromData(requests.get(thumbnail_path).content)

        pixmap = QtGui.QPixmap.fromImage(image)

        pixmap = pixmap.scaled(self.button.size())#, aspectRatioMode=QtCore.Qt.KeepAspectRatio)

        self.button.setIcon(pixmap)
        self.button.setIconSize(pixmap.size())

    def launch_task(self):
        self.clicked.emit()



class LabeledStatus(labeled.LabeledCombo):
    type_values = {}

    def __new__(cls, *args, **kwards):
        if not 'view' in kwards:
            return cls
        entity_type = kwards['view']._entity_type

        if entity_type not in cls.type_values and 'view' in kwards:
            cls.type_values[entity_type] = helpers.init_status_list(kwards['view'], 'sg_status_list')

        kwards['values'] = cls.type_values[entity_type]
        instance = super(LabeledStatus, cls).__new__(cls, *args, **kwards)

        return instance

    def __init__(self, value, label, parent=None, values=None, view=None):
        super().__init__(value, label, parent, values)
        self.setValues(self.type_values[view._entity_type])
        self.setValue(value)

    def setValues(self, values):
        self.values = values
        self.value_widget.clear()
        self.value_widget.addItems(values)

class LabeledNote(labeled.LabeledWidget):
    arrange = 'vertical'

    def __init__(self, value, label, parent=None):
        super(LabeledNote, self).__init__(value, label, parent=parent)
        self.setFixedHeight(90)

        self.add_value_widget()
    def add_value_widget(self):
        self.value_widget = QtWidgets.QPlainTextEdit(self.value)
        self.value_widget.setFixedHeight(80)
        self.value_widget.setObjectName('Value')
        self.layout.addWidget(self.value_widget)

    def setValue(self, value):
        self.value_widget.setText(value)
        self.value = value
