import os
import importlib

from pprint import pprint

def get_latest_version(item, pipeline_step, variant_name, version_status=None, version=None):
    item.precache_dependencies(fields=['sg_published_elements'])

    if version is not None:
        version = int(version)

    print('version', version)
    print('version_status', version_status)

    published_elements = item.sg_published_elements
    if published_elements.empty:
        return None
    published_elements.precache_dependencies(fields=['sg_step', 'sg_variant'])
    sg_database = item._database
    variant_view = sg_database['CustomEntity11'][variant_name]
    step_view = sg_database['Step'][pipeline_step]

    latest_version = published_elements.find_with_filters(sg_variant=variant_view,
                                                    sg_step=step_view,
                                                    sg_complete=True,
                                                    sg_delete=False,
                                                    sg_status_list=version_status,
                                                    sg_version_number=version,
                                                    single_item=True)
    if latest_version.empty:
        return None

    return latest_version


def get_tag_path(item, pipeline_step, variant_name, tag='scene', version_status=None, version=None):
    latest_publish = get_latest_version(item, pipeline_step, variant_name, version_status=version_status, version=version)

    if version_status is None and latest_publish is None:
        latest_publish = get_latest_version(item, pipeline_step, variant_name)

    if latest_publish is None or latest_publish.empty:
        return None

    base_path = latest_publish.sg_published_folder
    pprint(latest_publish.sg_files)
    relative_path = latest_publish.sg_files.get(tag)

    full_path = os.path.join(base_path, relative_path)
    full_path = full_path.replace('\\', '/')

    return full_path


def get_source_scene(item, pipeline_step, variant_name):
    latest_publish = get_tag_path(item, pipeline_step, variant_name)
    return latest_publish


def get_asset_path(project, asset_name, pipeline_step, variant_name, tag, version_status=None, version=None):

    import shotgrid_lib.database as database


    # importlib.reload(database)

    sg_database = database.DataBase()
    sg_database.fill(project, precatch=False)


    filters = [['code', 'is', asset_name]]
    sg_database.query_sg_database('Asset', filters=filters)

    item = sg_database['Asset'][asset_name]
    full_path = get_tag_path(item, pipeline_step, variant_name, tag=tag, version_status=version_status, version=version)
    print('get asset path:', full_path)

    return {'asset_path': full_path, 'output_path': full_path}

if __name__ == '__main__':
    project = 'TPT'
    asset_name = 'CupLeo'
    variant = 'Master'
    pipeline_step = 'Modeling'
    tag = 'usd'

    get_asset_path(project, asset_name, pipeline_step, variant, tag, version=1)

