import getpass
import logging

import shotgrid_lib.database as database

logger = logging.getLogger(__name__)

def create_new_publish(sg_database, publish_type, parameters, server):
    logger.info(' %s Create new publish %s' % ('-' * 10, '-' * 10))
    project = sg_database.project
    task_name = parameters['task_code']
    entity_name = parameters['entity_name']

    sg_database.query_sg_database('HumanUser', as_precache=True, filters=[])
    sg_database.query_sg_database('Project', as_precache=True)

    publish_type_view = sg_database['CustomEntity10'][publish_type]

    context_type = publish_type_view.sg_context_type

    context_view = sg_database.entity_view(context_type)[entity_name]

    filters = [['project.Project.code', 'is', project],
               ['sg_asset', 'name_is', entity_name]]

    sg_database.query_sg_database('CustomEntity09', filters=filters, update=True)

    all_published = sg_database['CustomEntity09'].find_with_filters(sg_asset=context_view)

    #all_published = context_view.sg_published_elements

    version_number = 1
    task_view = context_view.tasks[task_name]
    variant_view = task_view.sg_variant
    user_view = sg_database['HumanUser'].find_with_filters(login=getpass.getuser(),
                                                           single_item=True)
    project_view = sg_database['Project'][project.upper()]

    if not all_published.empty:
        if parameters.get('subset'):
            published_view = all_published.find_with_filters(sg_publish_type=publish_type_view, sg_subset=parameters['subset'])
        else:
            published_view = all_published.find_with_filters(sg_publish_type=publish_type_view, sg_variant=variant_view)

        if not published_view.empty:
            print(max(published_view))
            version_number = int(max(published_view).sg_version_number + 1)
        else:
            logger.info('No last version found, initiating version list')
    else:
        logger.info('No version found, initiating version list')

    publish_folder = publish_type_view.sg_path_pattern
    code_pattern = publish_type_view.sg_code_pattern

    publish_record = database.Record('CustomEntity09')
    publish_record.sg_publish_type = publish_type_view
    publish_record.sg_task = task_view
    publish_record.sg_version_number = version_number
    publish_record.description = parameters.get('comment')
    publish_record.project = project_view
    publish_record.sg_artist = user_view.as_shotgun()
    if parameters.get('metadata'):
        publish_record.sg_metadata =str(parameters.get('metadata'))

    publish_record.sg_step = task_view.step
    publish_record.sg_down_dependencies = parameters.get('dependencies')
    if parameters.get('subset'):
        publish_record.sg_subset = parameters.get('subset')
    else:
        publish_record.sg_variant = variant_view

    if context_type == 'Shot':
        publish_record.sg_context = context_view
        publish_record.sg_asset = None
    elif context_type == 'Asset':
        publish_record.sg_asset = context_view
        publish_record.sg_asset_type = context_view.sg_asset_type.replace(' ', '_')
        publish_record.sg_context = None

    publish_record.sg_hash = publish_record.generate_publish_hash(publish_type_view)
    publish_record.code = publish_record.solve_pattern(code_pattern)
    publish_folder = publish_record.solve_pattern(publish_folder)
    publish_record.sg_published_folder = '%s/%s' % (server, publish_folder)
    if publish_folder.find('[') > -1:
        print(publish_folder)
        print(publish_record.sg_asset_type)

    latest_version_view = sg_database.append(publish_record)


    logger.info(' %s New publish with id: %s %s %s' % ('-' * 10, latest_version_view.id, latest_version_view.code, '-' * 10))
    print(' %s New publish with id: %s %s %s' % ('-' * 10, latest_version_view.id, latest_version_view.code, '-' * 10))
    return latest_version_view
