class EntityNotInShotgrid(Exception):
    def __init__(self, entity, message="The entity %s is not defined in the Shotgrid scheme"):
        self.entity = entity
        self.message = message % entity
        super().__init__(self.message)


class ViewIsEmpty(Exception):
    def __init__(self, entity, message="This %s view is empty and can not be used in this operation"):
        self.entity = entity
        self.message = message % entity
        super().__init__(self.message)


class IsNotView(Exception):
    def __init__(self, var_type, message="This variable is not a view: type %s"):
        self.var_type = var_type
        self.message = message % var_type
        super().__init__(self.message)


class ViewIsDifferentEntity(Exception):
    def __init__(self, entity, correct_entity,
                 message="This view is from a different entity (%s) and can not be used in this operation, should be (%s)"):
        self.entity = entity
        self.correct_entity = correct_entity
        self.message = message % (self.entity, self.correct_entity)
        super().__init__(self.message)


class EntityNotInConfig(Exception):
    def __init__(self, entity, message="The entity %s is not defined in the module config scheme"):
        self.entity = entity
        self.message = message % entity
        super().__init__(self.message)


class FieldNotInEntity(Exception):
    def __init__(self, field, entity, message="The field %s is not present in the table %s"):
        self.entity = entity
        self.field = field

        self.message = message % (field, entity)
        super().__init__(self.message)


