import os
import sys

from urllib.parse import urlparse, parse_qs
import library.core.dynamic_run as dynamic_run

root_path = os.path.dirname(os.path.abspath(__file__))
if __name__ == '__main__':

    new_file = open('%s/log.txt' % root_path, 'w')
    try:
        argument = sys.argv[1]
        argument_parse = urlparse(argument)

        new_file.write('scheme %s\n' % str(argument_parse.scheme))
        new_file.write('netloc %s\n' % str(argument_parse.netloc))
        new_file.write('path %s\n' % str(argument_parse.path))
        new_file.write('params %s\n' % str(argument_parse.params))
        new_file.write('query %s\n' % str(argument_parse.query))
        new_file.write('fragment %s\n' % str(argument_parse.fragment))

        arguments = parse_qs(argument_parse.query)
        clean_arguments = {}
        for key, value in arguments.items():
            value = value[0]
            if key.endswith('_id') and value.isdigit():
                value = int(value)
            elif key.endswith('_ids') or key == 'ids':
                value = [int(val) for val in value.split(',')]
            new_file.write('query: %s =  %s %s \n' % (key, value, type(value)))
            clean_arguments[key] = value

        bits = argument_parse.netloc.rsplit('.', 1)
        print(bits)
        module_name = bits[0]
        function_name = bits[1]

        function_data = {'module': module_name,
                         'function': function_name,
                         'args': clean_arguments}

        new_file.write('module: %s \n' % module_name)
        new_file.write('function: %s \n' % function_name)

        status = dynamic_run.run_scripts(function_data)
        new_file.write('status: %s \n' % str(status))

    except Exception as e:
        new_file.write('%s\n' % str(e))


