import shotgrid_lib.database as database
import json



def store_schema(connection):
    store_root_path = '/shotgrid_lib/config/database_schema'

    full_schema = connection.schema_read()

    for entity_name, entity_schema in full_schema.items():
        print(entity_name)
        full_path = '%s/%s.json' % (store_root_path, entity_name)

        with open(full_path, 'w', encoding='utf-8') as f:
            json.dump(entity_schema, f, ensure_ascii=True, indent=4)




def create_field(connection, entity_type, name, data_type, field_data):

    connection.schema_field_create(entity_type,
                                   data_type,
                                   name,
                                   properties=field_data)


if __name__ == '__main__':
    sg_database = database.DataBase()
    sg_database.fill('SGD', precatch=False)
    connection = sg_database.sg

    create_field(connection, 'CustomEntity09', 'sg_')
    #store_schema(connection)