
import os
import yaml
import json

from pprint import pprint

import shotgun_api3


def get_old_connection():
    server= 'https://tds.shotgunstudio.com'
    script_name= 'Interface'
    api_key='dxfvstbke8zfzLmoacdlno@va'

    connection = shotgun_api3.Shotgun(server,
                                      script_name=script_name,
                                      api_key=api_key)

    return connection

def create_connection():
    server = 'https://atlantisanimation.shotgrid.autodesk.com/'
    api_key = 'vgihpozc&omuxsdbacwkZyh2j'
    script_name = 'shotgrid_connection'

    connection = shotgun_api3.Shotgun(server,
                                      script_name=script_name,
                                      api_key=api_key)

    return connection

def read_schema(entity):

    schema_file_path = 'C:/dev/shotgrid_lib/config/database_schema/%s.json' % entity

    with open(schema_file_path) as schema_file:
        entity_data = yaml.load(schema_file, Loader=yaml.loader.SafeLoader)

    return entity_data

def compare_dict(dict_a, dict_b):
    added = {}
    for key_a, value_a in dict_a.items():
        if key_a not in dict_b:
            added[key_a] = value_a
        else:
            value_b = dict_b[key_a]
            if value_a == value_b:
                continue

            if isinstance(value_a, dict) and isinstance(value_b, dict):
                diferences = compare_dict(value_a, value_b)
                if diferences:
                    added[key_a] = diferences
            else:
                added[key_a] = value_a

    return added

def create_field(connection, entity, field_name, diferences):
    if 'properties' not in diferences:
        return
    description = diferences.get('description', {}).get('value', 'updated from SGD')
    if not description:
        description = 'updated from SGD'
    properties = {'description': description}

    if 'valid_types' in diferences['properties']:
        properties['valid_types'] = diferences['properties']['valid_types']['value']

    if 'valid_values' in diferences['properties']:
        properties['valid_values'] = diferences['properties']['valid_values']['value']


    field_type = diferences['data_type']['value']
    try:
        new_name = connection.schema_field_create(entity, field_type, diferences['name']['value'], properties)
        print(new_name)

    except:
        pass

def compare_database_entity(connection, entity):
    current_entity_schema = connection.schema_field_read(entity)
    print(current_entity_schema.keys())
    saved_entity_schema = read_schema(entity)
    print(saved_entity_schema.keys())

    diferences = compare_dict(saved_entity_schema, current_entity_schema)
    for field_name, field_value in diferences.items():

        create_field(connection, entity, field_name, saved_entity_schema[field_name])


if __name__ == '__main__':
    connection = create_connection()
    entity = 'CustomEntity12'


    old_connection = get_old_connection()

    project_filters = [['code', 'is', 'TPT']]
    current_project = connection.find_one('Project', filters=project_filters)


    filters = [['project.Project.code', 'is', 'SGD']]
    schema = read_schema('CustomEntity10')

    fields = ['code',
              'description',
              #'project',
              'sg_code_pattern',
              'sg_context_type',
              'sg_hash_fields',
              'sg_path_pattern',
              'sg_server',
              ]
    all_types = old_connection.find('CustomEntity10', filters=filters, fields=fields)

    for publish_type in all_types:
        publish_type.pop('id')
        publish_type.pop('type')
        publish_type['project'] = current_project
        connection.create('CustomEntity10', publish_type)

    #compare_database_entity(connection, entity)