import os
import importlib



def get_latest_version(item, pipeline_step, variant_name):
    print(item)
    item.precache_dependencies(fields=['sg_published_elements'])
    published_elements = item.sg_published_elements
    print(published_elements)
    published_elements.precache_dependencies(fields=['sg_step', 'sg_variant'])
    sg_database = item._database
    variant_view = sg_database['CustomEntity11'][variant_name]
    step_view = sg_database['Step'][pipeline_step]
    print(variant_view)
    print(step_view)
    versions = published_elements.find_with_filters(sg_variant=variant_view,
                                                    sg_step=step_view,
                                                    sg_complete=True)

    if not versions or versions.empty:
        return None

    latest_version = max(versions)

    return latest_version


def get_tag_path(item, pipeline_step, variant_name, tag='scene'):
    print(item)
    print(pipeline_step)
    print(variant_name)
    print('-' * 100)
    latest_publish = get_latest_version(item, pipeline_step, variant_name)

    if latest_publish.empty:
        return None

    base_path = latest_publish.sg_published_folder
    relative_path = latest_publish.sg_files.get(tag)

    full_path = os.path.join(base_path, relative_path)
    full_path = full_path.replace('\\', '/')

    return full_path


def get_source_scene(item, pipeline_step, variant_name):
    latest_publish = get_tag_path(item, pipeline_step, variant_name)
    return latest_publish


if __name__ == '__main__':
    import shotgrid_lib.database as database

    #importlib.reload(database)

    sg_database = database.DataBase()
    sg_database.fill('sgd')

    sg_database.query_sg_database('Asset', as_precache=True)

    item = sg_database['Asset']['LeoMesi']
    full_path = get_source_scene(item, 'Model', 'Low')
    print(full_path)

