import importlib
import logging

import library.core.dynamic_run as dynamic_run
import publisher.lib.processes_node as process_node

importlib.reload(dynamic_run)

DEFAULT_SCRIPT_MODULE= 'publisher.resources.scripts'

logger = logging.getLogger()


class RunPythonScript(process_node.ProcessesNode):

    def do_it(self):

        if self.script['module'].find('.') == -1:
            self.script['module'] = '%s.%s' % (DEFAULT_SCRIPT_MODULE, self.script['module'])

        if 'arguments' in self.script and 'project' in self.script['arguments']:
            self.script['arguments']['project'] = self.project

        if 'args' in self.script and 'project' in self.script['args']:
            self.script['args']['project'] = self.project

        if not 'function' in self.script:
            self.script['function'] = self.script['module'].split('.')[-1]

        logger.debug('Launching dynamic run')
        output = dynamic_run.run_scripts(self.script)
        logger.info('Finished')

        self.set_output_vars(output)
        

    def set_output_vars(self, output_data):

        if output_data and isinstance(output_data, dict):
            for key, value in output_data.items():
                logger.debug('Output: %s: %s' % (key, value))
                setattr(self, key, value)

