import logging

import maya.cmds as cmds

logger = logging.getLogger()

def check_transforms(node):
    success = True

    translate = cmds.getAttr('%s.translate' % node)
    rotate = cmds.getAttr('%s.rotate' % node)
    scale = cmds.getAttr('%s.scale' % node)
    print(translate, rotate, scale)

    if translate[0] != (0.0, 0.0, 0.0):
        logger.error('The render geometry root %s should be at position 0,0,0 ' % node)
        success = False

    if rotate[0] != (0.0, 0.0, 0.0):
        logger.error('The render geometry root %s should be set with rotate 0,0,0 ' % node)
        success = False

    if scale[0] != (1.0, 1.0, 1.0):
        logger.error('The render geometry root %s should be set with translate 0,0,0 ' % node)
        success = False

    return success

def fix_transforms(node):
    cmds.setAttr('%s.translate' % node, 0.0, 0.0, 0.0, type='double3')
    cmds.setAttr('%s.rotate' % node, 0.0, 0.0, 0.0, type='double3')
    cmds.setAttr('%s.scale' % node, 1.0, 1.0, 1.0, type='double3')

def check_roots(geometry='', proxy=''):
    success = True

    if not cmds.objExists(geometry):
        logger.error('Can\'t find node: %s' % geometry)
        return False

    render_nodes = cmds.listRelatives(geometry, c=True, f=True)
    if not render_nodes:
        logger.error('The group %s is empty:' % geometry)
        return False

    #if len(render_nodes) != 1:
    #    logger.error('There must be only one group under render ')
    #    return False

    for render_node in render_nodes:
    #render_node = render_nodes[0]
        success = check_transforms(render_node) and success

    if not cmds.objExists(proxy):
        return success

    proxy_nodes = cmds.listRelatives(proxy, c=True, f=True)
    if not proxy_nodes:
        return success

    #if len(proxy_nodes) != 1:
    #    logger.error('There must be only one group under proxy ')
    #    return False

    for proxy_node in proxy_nodes:
        #proxy_node = proxy_nodes[0]
        success = check_transforms(proxy_node) and success

    return success

def fix_roots(geometry='', proxy=''):
    success = True

    if not cmds.objExists(geometry):
        logger.error('Can\'t find node: %s' % geometry)
        return False

    render_nodes = cmds.listRelatives(geometry, c=True, f=True)

    if not render_nodes:
        logger.error('The group %s is empty:' % geometry)
        return False

    if len(render_nodes) != 1:
        logger.error('There must be only one group under render ')
        return False

    render_node = render_nodes[0]
    fix_transforms(render_node)

    if not cmds.objExists(proxy):
        return success

    proxy_nodes = cmds.listRelatives(proxy, c=True, f=True)
    if not proxy_nodes:
        return success

    if len(proxy_nodes) != 1:
        logger.error('There must be only one group under proxy ')
        return False

    proxy_node = proxy_nodes[0]
    fix_transforms(proxy_node)

    return success