import logging

logger = logging.getLogger()

import maya.cmds as cmds


def get_namespaces():
    return [nspace for nspace in cmds.namespaceInfo(lon=True, an=True)  
                       if nspace not in [':shared', ':UI']]


def validate_namespaces(root="|asset"):
    result = True
    list_nspace = get_namespaces()
    not_allowed_namespaces = list()
    
    if list_nspace:
        for ns_check in list_nspace:
            nsNest = cmds.ls("{}:*".format(ns_check), l=True)
            if len(nsNest) >= 1: 
                for nsN in nsNest:
                    if nsN.startswith(root):
                        if ns_check not in not_allowed_namespaces:
                            not_allowed_namespaces.append(ns_check)
                    else:
                        pass
            else:
                not_allowed_namespaces.append(ns_check)

    if not_allowed_namespaces:
        msg = "It was found the following not allowed namespaces: "
        for nspace in list_nspace:
            msg += f"{nspace}, "
        msg += "Please, use the fix to remove them."
        logger.error(f'{msg}')
        result = False

    return result


def delete_namespaces(root="|asset"):
    result = True
    list_nspace = get_namespaces()
    not_allowed_namespaces = list()
    
    if list_nspace:
        for ns_check in list_nspace:
            nsNest = cmds.ls("{}:*".format(ns_check), l=True)
            if len(nsNest) >= 1: 
                for nsN in nsNest:
                    if nsN.startswith(root):
                        if ns_check not in not_allowed_namespaces:
                            not_allowed_namespaces.append(ns_check)
                    else:
                        pass
            else:
                not_allowed_namespaces.append(ns_check)

    if not_allowed_namespaces:
        for nspace in not_allowed_namespaces:
            try:
                cmds.namespace(rm=nspace, mnr=True)
                logger.info(f"Namespace {nspace} was removed.")
            except:
                logger.error(f"Namespace {nspace} could not be removed.")
                result = False

    return result