import importlib
import os

import shotgrid_lib.shotgrid_helpers as shotgrid_helpers

importlib.reload(shotgrid_helpers)


def get_first_animated_frame():
    return 1001

def get_last_animated_frame():
    return 1100
def get_usdShape():
    import maya.cmds as cmds
    nodes = cmds.ls(type='mayaUsdProxyShape', long=True)
    if nodes:
        return nodes[0]
    return ''


def get_asset_name():
    return 'test'

def get_model_variant():
    import maya.cmds as cmds
    if not cmds.objExists('asset'):
        return 'None'
    return cmds.getAttr('asset.model_variant', asString=True)

def get_model_version():
    import maya.cmds as cmds
    if not cmds.objExists('asset'):
        return 'None'
    return cmds.getAttr('asset.model_version', asString=True)

def get_context():
    entity = ''
    pipe_context = os.environ.get('PIPE_CONTEXT')
    if not pipe_context:
        return None

    if pipe_context == 'Asset':
        pipe_asset_type = os.environ.get('PIPE_ASSET_TYPE')
        pipe_asset_name = os.environ.get('PIPE_ASSET_NAME')
        entity = '%s.%s' % (pipe_asset_type, pipe_asset_name)
    else:
        pipe_season = os.environ.get('PIPE_SEASON')
        pipe_episode = os.environ.get('PIPE_EPISODE')
        pipe_sequence = os.environ.get('PIPE_SEQUENCE')
        pipe_shot = os.environ.get('PIPE_SHOT')
        entity = '%s.%s.%s.%s' % (pipe_season, pipe_episode, pipe_sequence, pipe_shot)

    return entity

def get_asset_from_path(value):
    import os
    basename = os.path.basename(value)
    bits = basename.split('_')

    if len(bits) != 4:
        return ''
    asset_name = '%s_%s_%s' % (bits[0], bits[1][:3], bits[1][-2:])
    return asset_name


def get_first_frame():
    try:
        import maya.cmds as cmds

        return cmds.playbackOptions(q=True, min=True)
    except:
        return 101

def get_last_frame():
    try:
        import maya.cmds as cmds

        return cmds.playbackOptions(q=True, max=True)
    except:
        return 110

def get_elements():
    try:
        import maya.cmds as cmds
    except:
        return []
    
    all_paths = []

    valid_types = ['Set']
    ignored_nodes = ['sharedReferenceNode']
    assemblies = cmds.ls(type='Assembly')
    for assembly_name in assemblies:
        if cmds.getAttr('%s.assemblyType' % assembly_name) in valid_types:
            all_paths.append(cmds.getAttr('%s.path' % assembly_name))

    all_references = cmds.ls(type='reference')

    for reference_node in all_references:
        if reference_node in ignored_nodes:
            continue
        path = cmds.referenceQuery(reference_node, f=True)

        all_paths.append(path)

    return all_paths


def get_task_from_asset(value, project=None, task_step='Layout'):
    import shotgrid_lib.shotgrid_helpers as helpers
 
    asset_name = value.get('name')
    if not asset_name:
        return []

    sg_connection = helpers.init_connection()


    filters = [['project.Project.code', 'is', project],
               ['entity', 'name_is', asset_name],
               ['step', 'name_is', task_step]]
    fields = ['id', 'content', 'sg_status_list']
    all_task_data = sg_connection.find('Task', filters=filters, fields=fields)
    return [dt['content'] for dt in all_task_data]

def get_task_from_context(value, project=None, task_step='Modeling'):
    from pprint import pprint

    entity_name = value

    if not entity_name:
        return []
    bits = entity_name.split('_')
    if len(bits) < 4 or not bits[-1]:
        return


    sg_connection = shotgrid_helpers.init_connection()

    filters = [['project.Project.code', 'is', project],
               ['entity', 'name_is', entity_name],
               ['step', 'name_is', task_step]]
    fields = ['id', 'content', 'sg_status_list']
    all_task_data = sg_connection.find('Task', filters=filters, fields=fields)
    return [dt['content'] for dt in all_task_data]


def get_alembic_file():
    import maya.cmds as cmds
    all_assemblies = cmds.ls(type='Assembly')
    if not all_assemblies:
        return ''
    for assembly in all_assemblies:
        path = cmds.getAttr('%s.path' % assembly)
        if os.path.exists(path):
            return path

    return '--'


def get_assets(mock=None):
    return ['test', 'other', 'three', mock]

def get_selected():
    try:
        import maya.cmds as cmds
    except:
        return 'geo'
    selected = cmds.ls(sl=True)
    if selected and len(selected) == 1:
        return selected[0]
    return ''

def get_maya_scene_path():
    try:
        import maya.cmds as cmds
    except:
        return ''
    path = cmds.file(q=True, sn=True)
    return path.replace('\\', '/')

def get_shots(project=None, connection=None):
    if connection:
        sg_connection = connection
    else:
        sg_connection = shotgrid_helpers.init_connection()


    filters = [['project.Project.code', 'is', project]]
    fields = ['id', 'code', 'sg_status_list']
    all_shots_data = sg_connection.find('Shot', filters=filters, fields=fields)

    all_shots = {}
    for shot_data in all_shots_data:
        bits = shot_data['code'].split('_')
        all_shots[bits[0]] = all_shots.get(bits[0], {})
        all_shots[bits[0]][bits[1]] = all_shots[bits[0]].get(bits[1], {})
        all_shots[bits[0]][bits[1]][bits[2]] = all_shots[bits[0]][bits[1]].get(bits[2], [])
        all_shots[bits[0]][bits[1]][bits[2]].append(bits[3])
    shot_data = all_shots
    return shot_data


def get_assets_shotgun(project=None, asset_type=None):
    sg_connection = shotgrid_helpers.init_connection()


    filters = [['project.Project.code', 'is', project]]

    if asset_type:
        if isinstance(asset_type, list):
            filters.append(['sg_asset_type', 'in', asset_type])
        else:
            filters.append(['sg_asset_type', 'is', asset_type])

    fields = ['id', 'code', 'sg_status_list', 'sg_asset_type']
    all_shots_data = sg_connection.find('Asset', filters=filters, fields=fields)

    all_shots = {}
    for shot_data in all_shots_data:
        all_shots[shot_data['sg_asset_type']] = all_shots.get(shot_data['sg_asset_type'], [])
        all_shots[shot_data['sg_asset_type']].append(shot_data['code'])
    shot_data = all_shots
    return shot_data


if __name__ == '__main__':
    print(get_assets_shotgun())