import maya.cmds as cmds

import logging

logger = logging.getLogger()

def check_shader_assigment(geometry='', valid_shader='standardSurface'):
    success = True

    if not geometry:
        logger.error('No geometry node is selected')
        return False

    if not cmds.objExists(geometry):
        logger.error('No geometry node  %s don\'t exists in the scene' % geometry)
        return False

    all_down = cmds.listRelatives(geometry, ad=True, f=True)
    for maya_node in all_down:
        if cmds.nodeType(maya_node) != 'mesh':
            continue

        shaders = cmds.listConnections(maya_node, type='shadingEngine') or []
        if not shaders:
            logger.error('The geometry node %s don\'t have a shader assigned' % maya_node)
            success = False
            continue
        sg_group = shaders[0]
        connections = cmds.listConnections('%s.surfaceShader' % sg_group)
        if not connections:
            logger.error('The Shading group %s don\'t have a surface shader assigned' % sg_group)
            success = False
            continue

        shader = connections[0]
        if cmds.nodeType(shader) != valid_shader:
            logger.error('The shader assigned to  %s is not a valid shader type' % maya_node)
            print(shader, cmds.nodeType(shader) )
            success = False

    return success


def assign_base_shader(geometries_to_assign, shader_name='base_shader', shader_type='aiStandardSurface'):
    if cmds.objExists(shader_name) and cmds.objExists('%sSG' % shader_name):
        shading_group = '%sSG' % shader_name
    else:
        material = cmds.shadingNode(shader_type, name=shader_name, asShader=True)
        shading_group = cmds.sets(name="%sSG" % shader_name, empty=True, renderable=True, noSurfaceShader=True)
        cmds.connectAttr("%s.outColor" % material, "%s.surfaceShader" % shading_group)

    cmds.setAttr('%s.specular' % shader_name, 0)
    cmds.setAttr('%s.base_color' % shader_name, 1.0, 1.0, 1.0, type='double3')

    cmds.sets(geometries_to_assign, forceElement=shading_group)

def fix_shader_assigment(geometry='', valid_shader='aiStandardSurface'):
    success = True

    if not geometry:
        logger.error('No geometry node is selected')
        return False

    if not cmds.objExists(geometry):
        logger.error('No geometry node  %s don\'t exists in the scene' % geometry)
        return False

    geometries_to_assign = []

    all_down = cmds.listRelatives(geometry, ad=True, f=True)
    for maya_node in all_down:
        if cmds.nodeType(maya_node) != 'mesh':
            continue

        shaders = cmds.listConnections(maya_node, type='shadingEngine') or []
        if not shaders:
            geometries_to_assign.append(maya_node)
            continue

        sg_group = shaders[0]
        connections = cmds.listConnections('%s.surfaceShader' % sg_group)
        if not connections:
            success = False
            geometries_to_assign.append(maya_node)
            continue

        shader = connections[0]
        if cmds.nodeType(shader) != valid_shader:
            success = False
            geometries_to_assign.append(maya_node)

    if geometries_to_assign:
        assign_base_shader(geometries_to_assign, shader_type=valid_shader)
    return success