import logging
import time

import maya.cmds as cmds

logger = logging.getLogger()


def check_unloaded_plugins():
    success = True
    old_plugins = cmds.unknownPlugin(q=True, list=True)
    logger.debug('Deleting plugins:')

    if not old_plugins:
        logger.info('Not unloaded plugins in the scene:')

    if old_plugins:
        logger.error('Found these unloaded plugins in the scene:')
        for plugin in old_plugins:
            logger.error('Plugin: %s ' % plugin)
        success = False


    unknown_nodes = cmds.ls(type = "unknown")
    if unknown_nodes:
        logger.error('Found these unknown nodes in the scene:')
        success = False
        for node in unknown_nodes:
            logger.error('node: %s' % node)

    return success


def fix_unloaded_plugins():

    unknown_nodes = cmds.ls(type = "unknown")
    if unknown_nodes:
        logger.warning('Deleting these unknown nodes in the scene:')
        logger.warning('delete node: %s' % ', '.join(unknown_nodes))
        cmds.delete(unknown_nodes)

    old_plugins = cmds.unknownPlugin(q=True, list=True)

    if not old_plugins:
        return True

    for plugin in old_plugins:
        cmds.unknownPlugin(plugin, remove=True)
        logger.info('Deleting plugin: %s' % plugin)


