import ast
import os
import importlib
import shotgrid_lib.shotgrid_helpers as shotgrid_helpers


def create_version(sg_connection,
                   published_id,
                   movie_path,
                   project=None,
                   first_frame=None,
                   last_frame=None,
                   usd_layers= None):


    publish_data = shotgrid_helpers.get_publish_data_by_id(sg_connection, published_id, project)

    if publish_data['sg_context']:
        entity = publish_data['sg_context']
    else:
        entity = publish_data['sg_asset']

    data = {'code': publish_data['code'],
            'entity': entity,
            'sg_task': publish_data['sg_task'],
            'description': publish_data['description'],
            'sg_path_to_movie': movie_path,
            'user': publish_data['sg_artist'],
            'project': publish_data['project'],
            'sg_published_elements': [publish_data],
            'sg_status_list': 'pbl',
            'sg_version_number': publish_data['sg_version_number']
            }

    if isinstance(first_frame, int) and isinstance(last_frame, int):
        frame_range = '%i-%i' % (first_frame, last_frame)
        frame_count = last_frame - first_frame + 1

        data['frame_range'] = frame_range
        data['frame_count'] = frame_count

    new_version = sg_connection.create('Version', data)
    sg_connection.upload('Version', new_version['id'], movie_path, field_name="sg_uploaded_movie", display_name="Turntable")

    return new_version

def finish_publish(shotgrid_id=None,
                   movie=None,
                   project=None,
                   first_frame=None,
                   last_frame=None,
                   add_empty_layer=False
                   ):

    sg_connection = shotgrid_helpers.init_connection(project)
    new_version = None

    publish_data = shotgrid_helpers.get_publish_data_by_id(sg_connection, shotgrid_id, project)


    if movie and os.path.exists(movie):
        movie = movie.replace('\\', '/')
        new_version = create_version(sg_connection,
                                       shotgrid_id,
                                       movie,
                                       project=project,
                                       first_frame=first_frame,
                                       last_frame=last_frame)

    sg_connection.update('CustomEntity09', shotgrid_id, {'sg_complete': True, 'sg_status_list': 'recd'})

    output_data = {'shotgrid_id': shotgrid_id}
    if new_version:
        output_data['version'] = new_version

    if publish_data.get('sg_asset') and False:
        import usd.lib.usd_manager as usd_manager
        importlib.reload(usd_manager)

        asset_name = publish_data['sg_asset']['name']
        asset_type = publish_data['sg_asset.Asset.sg_asset_type']
        manager = usd_manager.UsdManager(project)
        manager.set_entity(asset_name, 'Asset', asset_type=asset_type)
        step = publish_data['sg_step']['name']
        variant = publish_data['sg_variant']['name']
        version = '%03d' % publish_data['sg_version_number']
        files = ast.literal_eval(publish_data['sg_files'])
        version_path = '%s/%s' % (publish_data['sg_published_folder'], files.get('usd'))
        manager.add_asset_version(step, variant, int(version), version_path, add_empty_layer=True)

        if not manager.exists_root_layer():
            manager.create_entity_assembly()



    return output_data

if __name__ == '__main__':
    import argparse

    parser = argparse.ArgumentParser(description='Shotgun event launcher')
    parser.add_argument('-i', '-id', '--shotgrid-id', dest='shotgrid_id', help='Shotgrid published element id', type=int)
    parser.add_argument('-m', '-movie', '--movie', dest='movie', help='Published element  movie', default='')
    parser.add_argument('-p', '-project', '--project', dest='project', help='Project to publish on')

    parser.add_argument('-s', '-start', '--start-frame', dest='first_frame', default=101, type=int, help='First frame of the turntable')
    parser.add_argument('-e', '-end', '--end-frame', dest='last_frame', default=148, type=int,
                        help='Last frame of the turntable')


    args = parser.parse_args()
    finish_publish(shotgrid_id=args.shotgrid_id,
                   project=args.project,
                   movie=args.movie,
                   first_frame=args.first_frame,
                   last_frame=args.last_frame)
