import logging

logger = logging.getLogger()

import maya.cmds as cmds

def root_visibilities(roots=None):
    result = True

    if not roots:
        logger.error('Roots are not defined, please contact with pipline team to solve this issue.')
        return False

    for rt in roots:
        logger.info("Checking visibility of the mandatory nodes: {}".format(rt))
        if not cmds.objExists(rt):
            logger.error('Can not find node: {}. This node is mandatory to allow the publication.'.format(rt))
            result = False

        elif not cmds.getAttr(rt + '.visibility'):
            logger.error('The visibility of {} is off, please turn it on '.format(rt) \
                         + 'to can continue with the publication.')
            result = False
    
    return result