import library.core.config_manager as config_manager
import os
import sys
from PySide import QtCore, QtGui, QtWidgets

os.environ['PROJECT']='TPT'
os.environ['SHOTGRID_LIB_VERSION']='1.0.0'
os.environ['LIBRARY_VERSION']='1.0.0'
os.environ['LAUNCHER_VERSION']='1.0.0'
import shotgrid_lib.database as database
import production_tools.lib.set_environment as set_environment

class ImportAssetsFromLibraryWindow(QtWidgets.QMainWindow):
    def __init__(self, project):
        super(ImportAssetsFromLibraryWindow, self).__init__()
        self.setWindowTitle("Import assets")

        icon_path = "icons/import_assets.png"
        self.setWindowIcon(QtGui.QIcon(icon_path))

        self.project = project
        self.project_environment = set_environment.ProjectEnvironment(project=self.project)

        self.database_from_project(project)

        vlayout = QtWidgets.QVBoxLayout()

        layout_project = QtWidgets.QHBoxLayout()
        label = QtWidgets.QLabel("Project")
        label.setFixedWidth(50)
        self.project_combo = QtWidgets.QComboBox()
        layout_project.addWidget(label)
        layout_project.addWidget(self.project_combo)

        self.label_project_name = QtWidgets.QLabel()
        self.label_project_name.setEnabled(False)

        layout_actions = QtWidgets.QHBoxLayout()
        button_import = QtWidgets.QPushButton("Import")
        button_cancel = QtWidgets.QPushButton("Cancel")
        layout_actions.addWidget(button_import)
        layout_actions.addWidget(button_cancel)

        vlayout.addLayout(layout_project)
        vlayout.addWidget(self.label_project_name, alignment=QtCore.Qt.AlignCenter)
        vlayout.addLayout(layout_actions)

        self.init_project_combo()

        self.project_combo.currentIndexChanged.connect(self.on_project_changed)
        button_import.clicked.connect(self.on_import_clicked)
        button_cancel.clicked.connect(self.on_cancel_clicked)

        self.main_layout = QtWidgets.QVBoxLayout()
        self.main_layout.addLayout(vlayout)

        central_widget = QtWidgets.QWidget()
        central_widget.setLayout(self.main_layout)

        self.setCentralWidget(central_widget)
        self.resize(300, 100)
        return

    def database_from_project(self, project):
        self.project = project
        self.database = database.DataBase()
        self.database.fill(self.project, True)
        return

    def refresh_project_name(self):
        print("REFRESH project with: " + self.project)
        #TODO : name in scheme.yaml ok for database
        #self.label_project_name.setText(self.database.project.name)
        return

    def init_project_combo(self):

        for project_name in self.project_environment.company_config['active_projects']:
            project_folder = self.project_environment.company_config['projects_roots'][project_name]
            full_name = os.path.join(project_folder, 'config', 'project.yaml')
            if os.path.exists(full_name):
                self.project_combo.addItems([project_name])

        project_lower = self.project.lower()
        index = -1
        for i in range(self.project_combo.count()):
            if self.project_combo.itemText(i).lower() == project_lower:
                index = i
                break
        if index != -1:
            self.project_combo.setCurrentIndex(index)

        self.refresh_project_name()
        return

    def on_project_changed(self, index):
        self.project = self.project_combo.itemText(index)
        if self.database.project == self.project:
            print('Same database project')
            return

        #TODO###
        #how to change the database for another project
        self.config_solver = config_manager.ConfigSolver(project=self.project)
        self.database_from_project(project)
        #self.database_from_project(self.project) AND NO project from where ?
        self.refresh_project_name()
        ########
        return

    def testImportAsset(self, asset_name):

        ##### PROJECT is missing in new_asset BUT we can't have it : we need to add
        new_asset = database.Record('Asset')
        new_asset.code = "Batman"
        new_asset.project  = self.database['Project']
        #new_asset.task_template = self.database['TaskTemplate']['Hero Character - Asset']
        self.database.append(new_asset)

        #TODO :
        # we need to add in scheme.yaml : TaskTemplate / project in Asset...
        # we need to have 2 database or one asset library...
        '''
        print('---------- ASSET CREATION -----------')
        new_breakdown = database.Record('CustomEntity12')
        shot_view = sg_database['Shot']['s00_ep02_sq010_sh010']
        asset_view = sg_database['Asset']['Tentacle']
        project = asset_view.project
        variant_master_view = sg_database['CustomEntity11']['Master']
        variant_purple = sg_database['CustomEntity11']['TentaclePurple']
        new_breakdown.sg_link = shot_view
        new_breakdown.sg_instance = 2
        new_breakdown.sg_asset = asset_view
        new_breakdown.code = asset_view.code
        new_breakdown.project = project
        new_breakdown.sg_geometry_variant = variant_master_view
        new_breakdown.sg_shading_variant = variant_purple
        new_breakdown.sg_alias = 'Auto Record'

        sg_database.append(new_breakdown)

        print('---------- Retrieve all variants tasks of one asset -----------')
        asset_view = sg_database['Asset']['Tentacle']
        for task in asset_view.tasks:
            if task.empty:
                continue
            print('------ Task = ' + task.content)
            # print(task.task_assignees_name, task.sg_status_list)
            print('Variant Name = ' + task.sg_variant.code)
        '''
        return

    def on_import_clicked(self):
        self.testImportAsset("LeoHero")
        return

    def on_cancel_clicked(self):
        window.close()
        return

def open_tools_import_assets(project):
    print('open pack tools', project)
    tool_window = ImportAssetsFromLibraryWindow(project=project)
    tool_window.show()

if __name__ == '__main__':
    app = QtWidgets.QApplication(sys.argv)

    with open("styles.qss", "r") as f:
        stylesheet = f.read()
    app.setStyleSheet(stylesheet)

    project = os.environ.get('PROJECT', 'tpt')
    window =ImportAssetsFromLibraryWindow(project=project)
    window.show()

    ex = app.exec()
    sys.exit(ex)