import sys
import os
import importlib
import importlib.util as ip_util
import yaml


from importlib.abc import MetaPathFinder, Loader

class VersionedPathFinder(MetaPathFinder, Loader):

    def __init__(self, ):
        super(VersionedPathFinder, self).__init__()
        self.company_root = os.environ.get('COMPANY_ROOT', r'\\company\company')
        self.ignored_packages = ['python',
                                 'maya',
                                 'arnold',
                                 'mayaUsd',
                                 'PySide6',
                                 'PySide2',
                                 'krita',
                                 'prod',
                                 'nuke',
                                 'git',
                                 'maya_usd',
                                 'houdini',
                                 'substance_painter',
                                 'substance_library',
                                 'maya_bifrost',
                                 'nerf',
                                 'photoshop',
                                 'gimp']
        self.renamed_packages = {'asset_library': 'asset-library',
                                 'maya_scene_manager': 'maya-scene-manager'}

        tokens_file_path = os.path.join(self.company_root, 'config', 'gitlab_tokens.yaml')
        with open(tokens_file_path, 'r') as y_file:
            tokens_file_data = yaml.safe_load(y_file)

        self.git_username = tokens_file_data['user_name']
        self.git_tokens = tokens_file_data['tokens']

        self.local_tools_path = 'C:/pipeline/tools'
        
        self.server_tools_path = r'%s\tools' % self.company_root

        if 'TOOLS_ROOT' in os.environ:
            print('Using tools root: %s' % os.environ['TOOLS_ROOT'])
            self.tools_path = os.environ['TOOLS_ROOT']

        elif os.environ.get('LOCAL_PIPELINE', False):
            print('Using local deploy')
            self.tools_path = self.local_tools_path
        else:
            print('Using server deploy')
            self.tools_path = self.server_tools_path

        self.dev_path = 'C:/dev'
        # git@gitlab.com:inefecto-tnf/tara-project/packages_io.git
        self.repo_url = 'https://gitlab.com/inefecto-tnf/tara-project'
        self.repo_url_tokens = 'https://%s:%s@gitlab.com/inefecto-tnf/tara-project'

    def get_tool_from_repo(self, tool_name, tool_version):
        print('get from git: %s' % tool_name, tool_version)
        import subprocess
        repo_path = os.path.join(self.tools_path, tool_name, tool_version)

        tool_repo_name = self.renamed_packages.get(tool_name, tool_name)
        print(tool_name)
        print(self.git_tokens.keys())
        if tool_name in self.git_tokens:
            current_repo = '%s/%s.git' % (self.repo_url_tokens % (self.git_username, self.git_tokens[tool_name]), tool_repo_name)
        else:
            return None
            current_repo = '%s/%s.git' % (self.repo_url, tool_repo_name)
        print(current_repo)
        command = '"C:/Program Files/Git/cmd/git.exe" clone {} --branch {} --single-branch {}'.format(current_repo, tool_version, repo_path)
        #print(command)
        subprocess.call(command)
        full_path = os.path.join(self.tools_path, tool_name, tool_version, '__init__.py')
        if os.path.exists(full_path):
            spec = importlib.util.spec_from_file_location(tool_name, full_path)
            return spec
        return None

    def check_numeric_version(self, tools_path, package_name, version):
        if version == 'local':
            return
        import subprocess
        bits = version.split('.')

        if len(bits) == 3:
            numeric = True
            for bit in bits:
                numeric = numeric & bit.isdigit()
            if numeric:
                return

        current_repo = '%s/%s/%s' % (tools_path, package_name, version)
        command = '"C:/Program Files/Git/cmd/git.exe" pull'
        if os.path.exists(current_repo):
            subprocess.run(command, cwd=current_repo)


    def find_spec(self, fullname, path, target=None):

        # extract module name from fullname
        bits = fullname.split(".")
        mod_name = bits[-1]
        package_name = bits[0]
        if package_name in self.ignored_packages:
            #print('ignoring import: %s' % fullname)
            return
        version = os.environ.get('%s_VERSION' % package_name.upper())
        if not version:
            return None
            
        if version == 'local':
            tools_path = self.dev_path
        else:        
            tools_path = self.tools_path
        #print(tools_path)
        #print('>>', fullname, package_name, version, tools_path)
        
    # path is None or a list of paths, we use os.curdir when it's None
    
        if len(bits) > 1:
            local_path = '/'.join(bits[1:])
            if version != 'local':
                full_path = os.path.join(tools_path, package_name, version, local_path)
            else:
                full_path = os.path.join(tools_path, package_name, local_path)
        else:
            if version != 'local':
                full_path = os.path.join(tools_path, package_name, version)
            else:
                full_path = os.path.join(tools_path, package_name)

        check_path = '%s.py' % full_path
        info_path = None
        if os.path.exists(check_path):
            full_path = check_path
        else:
            info_path = os.path.join(full_path, '%s.yaml' % package_name)
            full_path = os.path.join(full_path, '__init__.py')

        if os.path.exists(full_path):
            self.check_numeric_version(tools_path, package_name, version)
            spec = ip_util.spec_from_file_location(fullname, full_path)
            return spec

        elif info_path and os.path.exists(info_path):
            return None
        elif len(bits) == 1 and version != 'local':
            #return None
            spec = self.get_tool_from_repo(mod_name, version)
            return spec
        
        # return None to tell the python this finder can't find the module
        return None


def init():
    sys.meta_path.insert(0, VersionedPathFinder())


#init()
# insert a MyMetaPathFinder instance at the start of the meta_path list
if __name__ == '__main__':
    sys.meta_path.append(VersionedPathFinder())

    #import library
    #print(library)
    #import library.core.parser_function as test
    #print(test)
    import publisher.bin.publisher_gui as pub_gui
    print(pub_gui)
