import os
import sys


def get_python_version():
    app = os.path.splitext(os.path.basename(sys.executable))[0].lower()
    python_compact = '%s%s' % (sys.version_info.major, sys.version_info.minor)

    if app == 'python':
        python_version = '%s.%s' % (sys.version_info.major, sys.version_info.minor)

    elif app == 'maya' or app == 'mayapy':
        python_version = 'maya_%s.%s' % (sys.version_info.major, sys.version_info.minor)
    else:
        python_version = '3.11'
        #python_version = '%s.%s' % (sys.version_info.major, sys.version_info.minor)

    print('-' * 2, 'site customize', app, python_version, '-' * 2)

    return python_version, python_compact


def set_environ(python_version, python_compact):

    tools_path = os.environ.get('TOOLS_ROOTS', r'C:\pipeline\tools')
    if not tools_path:
        print('cant find env var TOOLS_ROOT')
        return False

    libraries_root = r'\\columbus\SGD\company\tools'
    library_path = '%s/python/%s/Lib/site-packages' % (libraries_root, python_version)
    zip_path = '%s/python/%s/Scripts/python%s.zip' % (libraries_root, python_version, python_compact)
    script_path = '%s/python/%s/Scripts' % (libraries_root, python_version)

    to_clean = []

    for path in sys.path:
        clean_path = path.lower().replace('\\', '/')
        if clean_path.startswith('%s/python' % tools_path.lower()) or clean_path == tools_path.lower():
            to_clean.append(path)

    for path in reversed(to_clean):
        sys.path.remove(path)

    print('+', library_path)
    sys.path.insert(0, library_path)
    print('+', zip_path)
    sys.path.insert(0, zip_path)
    print('+', script_path)
    sys.path.insert(0, script_path)

    print('+', tools_path)
    sys.path.insert(0, tools_path)

    if python_version.startswith('maya') and 'MAYA_USD_ROOT' in os.environ:
        usd_path = '%s/mayausd/USD/lib/python' % os.environ['MAYA_USD_ROOT']
        print('+', usd_path)

        sys.path.insert(0, usd_path)

    return True


def customize():
    python_version, python_compact = get_python_version()
    success = set_environ(python_version, python_compact)
    # if not success:
    #    return

    import version_finders
    version_finders.init()


customize()