import os
import sys
import shutil
import subprocess
import urllib
from pprint import pprint

needed_libraries = ['pyyaml']

HEADER = '\033[95m'
OKBLUE = '\033[94m'
OKCYAN = '\033[96m'
OKGREEN = '\033[92m'
WARNING = '\033[93m'
FAIL = '\033[91m'
ENDC = '\033[0m'
BOLD = '\033[1m'
UNDERLINE = '\033[4m'

def print_info(line, color=OKGREEN):
    print('%s%s%s' % (color, line, ENDC))

def run_cmd(cmd):
    environ = os.environ.copy()
    sp = subprocess.Popen(cmd,
                          stderr=subprocess.PIPE,
                          stdout=subprocess.PIPE,
                          shell=True,
                          env=environ)

    out, err = sp.communicate()
    if out:
        for line_raw in str(out.decode("utf-8")).split('\n'):
            line = line_raw.replace('\r', '')
            if not line:
                continue
            if line[0] in ['+', '-']:
                print_info(line, color=OKCYAN)
            else:
                print_info(line, color=OKBLUE)
    if err:
        for line in str(err.decode("utf-8")).split('\n'):
            if line.lower().find('error') > -1:
                print_info(line, color=FAIL)
            else:
                print_info(line, color=WARNING)

    return out, err


def find_pip(executable):
    print('executable: %s' % executable)
    executable = executable.replace('\\', '/')
    scripts_folder = os.path.dirname(executable)
    root_folder = os.path.dirname(scripts_folder)
    print(root_folder)
    for root, dirs, files in os.walk(root_folder):
        if 'pip.exe' in files:
            return os.path.join(root, 'pip.exe')

    return None

def get_needed_libraries():
    return
    executable = sys.executable
    pip_path = find_pip(executable)
    pip_path = pip_path.replace('\\', '/')
    print('pip path %s' % pip_path)
    for library in needed_libraries:
        cmd = [executable, pip_path, 'install', library, '--upgrade']
        run_cmd(cmd)


def uncompress_archive( output_folder, zip_file):
    try:
        shutil.unpack_archive(zip_file, output_folder, 'zip')
    except:
        import zipfile
        with zipfile.ZipFile(zip_file, 'r') as zip_ref:
            zip_ref.extractall(output_folder)


def extract_python_versions(deploy_path, local_path):
    resources_path = os.path.join(deploy_path, 'resources', 'python')
    if not os.path.exists(resources_path):
        return
    for version in os.listdir(resources_path):
        full_path = os.path.join(resources_path, version)
        folder, python_version = version.split('_', 1)
        python_version = python_version.rsplit('.',1)[0]
        full_output_path = os.path.join(local_path, folder, python_version, 'Scripts')
        if os.path.exists(full_output_path):
            shutil.rmtree(full_output_path)
        os.makedirs(full_output_path)
        uncompress_archive(full_output_path, full_path)

def recursive_chown(path):
    return
    os.chmod(path, 775)
    for dir_path, dir_names, filenames in os.walk(path):
        os.chmod(dir_path, 775 )
        for filename in filenames:
            os.chmod(os.path.join(dir_path, filename), 775 )

def install_dependencies(local_path):
    import yaml

    this_folder = os.path.dirname(os.path.abspath(__file__))
    root_folder = os.path.dirname(this_folder)
    dependencies_config_file = os.path.join(root_folder, 'config', 'dependencies.yaml')
    with open(dependencies_config_file, 'r') as config_file:
        dependencies_config = yaml.safe_load(config_file)

    modules = dependencies_config['dependencies']
    for interpreter, interpreter_data in dependencies_config['interpreters'].items():
        print(interpreter)
        interpreter_name = str(interpreter_data['version'])
        interpreter_path = interpreter_data['path'].replace('<local_tools>', local_path)
        if not os.path.exists(interpreter_path):
            print_info('Can\'t find python interpreter %s' % interpreter_name, FAIL)
            print_info('Check path: %s' % interpreter_path, FAIL)
            continue

        interpreter_pip_path = interpreter_data['pip'].replace('<local_tools>', local_path)
        ignore_modules = interpreter_data.get('ignore', [])

        install_path = os.path.join(local_path, 'python', interpreter_name, 'Lib', 'site-packages')

        for module_name, module_version in modules.items():
            if module_name in ignore_modules:
                continue
            print_info('Installing module %s for python %s' % (module_name, interpreter_name), OKGREEN)

            if module_version == 'any':
                module_full_version = module_name
            else:
                module_full_version = '%s==%s' % (module_name, module_version)
            cmd = [interpreter_path, interpreter_pip_path, 'install', '-v', module_full_version, '-t', install_path]
            run_cmd(cmd)

        recursive_chown(install_path)

def get_global_config(company_root='V:/company'):
    import yaml

    company_config_path = '%s/config/global.yaml' % company_root
    with open(company_config_path, 'r') as config_file:
        global_config = yaml.safe_load(config_file)

    return global_config


def copy_python_versions(install_path):

    source_folder = r'\\columbus\SGD\company\tools\python_libraries'
    python_install_folder = os.path.join(install_path, 'python')
    for python_version_folder in os.listdir(source_folder):
        print('installing python interpreter and modules: %s' % python_version_folder)
        full_source_folder = os.path.join(source_folder, python_version_folder)
        full_target_folder = os.path.join(python_install_folder, python_version_folder)

        if not os.path.isdir(full_source_folder):
            continue

        print('source folder: %s' % full_source_folder)
        print('target folder: %s' % full_target_folder)

        shutil.copytree(full_source_folder, full_target_folder)


def download_python_versions(company_root='V:/company'):
    return
    print_info('Installing python interpreters', HEADER)
    import yaml

    this_folder = os.path.dirname(os.path.abspath(__file__))
    root_folder = os.path.dirname(this_folder)
    dependencies_config_file = os.path.join(root_folder, 'config', 'dependencies.yaml')
    with open(dependencies_config_file, 'r') as config_file:
        dependencies_config = yaml.safe_load(config_file)

    modules = dependencies_config['dependencies']
    for interpreter, interpreter_data in dependencies_config['interpreters'].items():
        if 'url' not in interpreter_data:
            continue

        download_url = interpreter_data['url']
        version = interpreter_data['version']
        zip_path = '%s/python/%s/zip/python.zip' % (company_root, version)
        folder = os.path.dirname(zip_path)
        if not os.path.exists(folder):
            os.makedirs(folder)

        print_info('python version: %s' % version, OKGREEN)
        print_info('\tDownloading python from: %s' % download_url, OKGREEN)
        try:
            urllib.urlretrieve(download_url, zip_path)
        except:
            import urllib.request as urlrequest
            urlrequest.urlretrieve(download_url, zip_path)

        print_info('\tDone', OKGREEN)
        scripts_folder = '%s/python/%s/Scripts' % (company_root, version)
        print_info('\tInstallation folder: %s' % scripts_folder, OKGREEN)

        if not os.path.exists(scripts_folder):
            os.makedirs(scripts_folder)

        uncompress_archive(scripts_folder, zip_path)
        print_info('\tSetting python site', OKGREEN)
        override_pth(scripts_folder, company_root)
        print_info('\tInstalling pip', OKGREEN)

        get_pip(scripts_folder, this_folder)


def get_pip(scripts_folder, this_folder):
    return
    python_exec = os.path.join(scripts_folder, 'python.exe')
    get_pip = os.path.join(this_folder, 'get-pip.py')
    command = [python_exec, get_pip]
    run_cmd(command)


def override_pth(scripts_folder, company_root):
    import glob

    file_pattern = os.path.join(scripts_folder, 'python*._pth')
    for file_path in glob.glob(file_pattern):
        basename = os.path.basename(file_path)
        basename = basename.split('.')[0]
        pth_file = open(file_path, 'w')
        pth_file.write('%s.zip\n' % basename)
        pth_file.write('..\\Lib\\site-packages\n')
        pth_file.write('.\n')
        pth_file.write('%s\n' % company_root.replace('/', '\\'))
        pth_file.write('import site\n')
        pth_file.write('')

        pth_file.close()

        # Uncomment to run site.main() automatically


def set_environment(company_root='V:/company'):
    os.environ['COMPANY_ROOT'] = company_root
    os.system('SETX COMPANY_ROOT %s' % company_root)


def set_local_pipeline(local_pipeline=False):
    os.environ['LOCAL_PIPELINE'] = local_pipeline
    os.system('SETX LOCAL_PIPELINE %s' % local_pipeline)


def install_global_config(company_root='V:/company', local_pipeline=False):
    import yaml

    set_environment(company_root=company_root)
    this_folder = os.path.dirname(os.path.abspath(__file__))
    root_folder = os.path.dirname(this_folder)
    global_config_file = os.path.join(root_folder, 'config', 'global.yaml')
    project_tools_file = os.path.join(root_folder, 'config', 'project_tools.yaml')

    with open(global_config_file) as inp_file:
        global_config = yaml.safe_load(inp_file)

    global_config['company_root'] = company_root
    global_config['root'] = '%s/tools' % company_root

    if local_pipeline:
        global_config['tools_root'] = global_config['local_tools']
    else:
        global_config['tools_root'] = global_config['root']

    output_config_file = os.path.join(company_root, 'config', 'global.yaml')
    dirname = os.path.dirname(output_config_file)
    if not os.path.exists(dirname):
        os.makedirs(dirname)

    with open(output_config_file, 'w') as outfile:
        yaml.dump(global_config, outfile, default_flow_style=False)

    output_project_tools_file = os.path.join(company_root, 'config', 'project_tools.yaml')
    shutil.copy2(project_tools_file, output_project_tools_file)

    return global_config


def install_site_customizer(global_config, local_install=False):

    if local_install:
        destination = global_config['local_tools']
    else:
        destination = global_config['root']
    if not os.path.exists(destination):
        os.makedirs(destination)

    this_folder = os.path.dirname(os.path.abspath(__file__))
    root_folder = os.path.dirname(this_folder)
    site_customizer_path = os.path.join(root_folder, 'lib', 'sitecustomize.py')
    version_finders_path = os.path.join(root_folder, 'lib', 'version_finders.py')

    print_info('Installing python customize.py', OKGREEN)
    shutil.copy2(site_customizer_path, destination)

    print_info('Installing site metapath finder', OKGREEN)
    shutil.copy2(version_finders_path, destination)


if __name__ == '__main__':
    print(find_pip())
    #get_needed_libraries()
    #c_root = 'C:/mock_server'
    #g_config = install_global_config(company_root=c_root)

