import os
import re

import importlib
import pipeline_updater.bin.pipeline_updater as pipeline_updater

importlib.reload(pipeline_updater)

path_pattern = re.compile('([a-zA-Z]):/')

yes_no_pattern = re.compile('([yYnN])')

def user_input(text, default_value=None, allow_empty=False, pattern=None):
    valid_output = False
    while valid_output is False:
        if default_value is not None:
            full_text = '%s ["%s"]: ' % (text, default_value)
        else:
            full_text = '%s: ' % text
        try:
            output = raw_input(full_text)
        except:
            output = input(full_text)

        if default_value is not None and output == '':
            output = default_value
            valid_output = True
        elif output == '':
            valid_output = False
        elif pattern:
            is_path = pattern.match(output)
            if is_path is not None:
                valid_output = True

    return output


class PipelineInstaller():
    def __init__(self, use_defaults=True):
        self.debug = False

        self.default_company_root = r'\\company\company'
        self.default_pipe_local = 'Y'
        if self.debug:
            self.default_company_root = 'C:/mock_server'
            self.default_pipe_local = True

        if not use_defaults:
            self.company_root = user_input('Company root', default_value=self.default_company_root)
            local_install = user_input('Locally installed', default_value='Y', pattern=yes_no_pattern)
        else:
            self.company_root = self.default_company_root
            local_install = 'Y'

        self.local_install = local_install in ['Y', 'y']
        pipeline_updater.get_needed_libraries()
        success = self.check_global_install()
        if not success:
            return
        self.set_environment_vars()

        success = self.install_python_interpreters()
        if not success:
            return

        #success = self.check_projects_install()
        #if not success:
        #    return


        self.install_launcher()

    def install_launcher(self):
        pipeline_updater.print_info('Installing pipeline launcher', pipeline_updater.OKGREEN)

        default_versions = self.global_config['default_versions']
        launcher_version = default_versions.get('launcher')
        python_version = default_versions.get('python')
        os.environ['PYTHON_VERSION'] = str(python_version)

        python_path = os.path.join(self.tools_root, 'python', str(python_version), 'Scripts', 'python.exe')

        for module, version in default_versions.items():
            if module == 'python':
                continue
            cmd = [python_path, '-c', 'import %s' % module]
            os.environ['%s_VERSION' % module.upper()] = version
            pipeline_updater.run_cmd(cmd)


    def set_environment_vars(self):
        print('set environment')
        pipeline_updater.print_info('Setting machine environment variables', pipeline_updater.OKGREEN)

        os.environ['COMPANY_ROOT'] = self.company_root
        os.system('C:/Windows/System32/setx.exe /m  COMPANY_ROOT %s' % self.company_root)

        pipeline_updater.print_info('set COMPANY_ROOT: %s' % self.company_root, pipeline_updater.OKGREEN)

        if self.local_install:
            local_install = '1'
        else:
            local_install = '0'
        os.environ['LOCAL_PIPELINE'] = local_install
        os.system('C:/Windows/System32/setx.exe /m LOCAL_PIPELINE %s' % local_install)

        pipeline_updater.print_info('set LOCAL_PIPELINE: %s' % local_install, pipeline_updater.OKGREEN)

        if self.local_install:
            os.environ['TOOLS_ROOT'] = self.global_config['local_tools']
            os.system('C:/Windows/System32/setx.exe /m TOOLS_ROOT %s' % self.global_config['local_tools'])
            pipeline_updater.print_info('set TOOLS_ROOT: %s' % self.global_config['local_tools'], pipeline_updater.OKGREEN)

            os.environ['PYTHONPATH'] = self.global_config['local_tools']
            os.system('C:/Windows/System32/setx.exe /m PYTHONPATH %s' % self.global_config['local_tools'])
            pipeline_updater.print_info('set PYTHONPATH: %s' % self.global_config['local_tools'], pipeline_updater.OKGREEN)

            self.tools_root = self.global_config['local_tools']
        else:
            os.environ['TOOLS_ROOT'] = self.global_config['root']
            os.system('C:/Windows/System32/setx.exe /m TOOLS_ROOT %s' % self.global_config['root'])
            pipeline_updater.print_info('set TOOLS_ROOT: %s' % self.global_config['root'], pipeline_updater.OKGREEN)

            os.environ['PYTHONPATH'] = self.global_config['root']
            os.system('C:/Windows/System32/setx.exe /m PYTHONPATH %s' % self.global_config['root'])
            pipeline_updater.print_info('set PYTHONPATH: %s' % self.global_config['root'], pipeline_updater.OKGREEN)
            self.tools_root = self.global_config['root']



    def install_python_interpreters(self):

        self.do_install_python_interpreters(self.local_install)
        pipeline_updater.install_site_customizer(self.global_config, local_install=self.local_install)

        return True

    def do_install_python_interpreters(self, local_install):
        if local_install:
            install_path = self.global_config['local_tools']
        else:
            install_path = self.global_config['root']

        pipeline_updater.download_python_versions(install_path)
        pipeline_updater.copy_python_versions(install_path)
        #pipeline_updater.install_dependencies(install_path)

    def check_projects_install(self):

        projects = self.global_config['active_projects']
        project_roots = self.global_config['projects_roots']
        for project in projects:
            project_root = project_roots[project]
            print('project: %s root: %s' % (project, project_root))

    def read_global_config(self):
        self.global_config = pipeline_updater.get_global_config(self.company_root)
        self.global_config['local_tools'] = 'C:/pipeline/tools'

    def check_global_install(self):
        global_config_path = os.path.join(self.company_root, 'config', 'global.yaml')
        if os.path.exists(global_config_path):
            pipeline_updater.print_info('Global config already installed', pipeline_updater.WARNING)
            pipeline_updater.print_info('Reading global config', pipeline_updater.WARNING)
            self.read_global_config()
            return True

        install_global = user_input('Install global config', default_value='Y', pattern=yes_no_pattern)
        if install_global in ['Y', 'y']:
            self.do_install_global()
        else:
            return False

        return True

    def do_install_global(self):

        pipeline_updater.install_global_config(company_root=self.company_root, local_pipeline=self.local_install)
        self.read_global_config()

if __name__ == '__main__':
    installer = PipelineInstaller()