"""
Constants for descriptor.

This file is automaticaly generated by tools/extract_terminology.py
"""
from enum import Enum as _Enum


class Klass(bytes, _Enum):
    """
    Klass definitions extracted from PITerminology.h.

    See https://www.adobe.com/devnet/photoshop/sdk.html
    """
    Action = b'Actn'
    ActionSet = b'ASet'
    Adjustment = b'Adjs'
    AdjustmentLayer = b'AdjL'
    AirbrushTool = b'AbTl'
    AlphaChannelOptions = b'AChl'
    AntiAliasedPICTAcquire = b'AntA'
    Application = b'capp'
    Arrowhead = b'cArw'
    Assert = b'Asrt'
    AssumedProfile = b'AssP'
    BMPFormat = b'BMPF'
    BackgroundLayer = b'BckL'
    BevelEmboss = b'ebbl'
    BitmapMode = b'BtmM'
    BlendRange = b'Blnd'
    BlurTool = b'BlTl'
    BookColor = b'BkCl'
    BrightnessContrast = b'BrgC'
    Brush = b'Brsh'
    BurnInTool = b'BrTl'
    CachePrefs = b'CchP'
    CMYKColor = b'CMYC'
    CMYKColorMode = b'CMYM'
    CMYKSetup = b'CMYS'
    Calculation = b'Clcl'
    Channel = b'Chnl'
    ChannelMatrix = b'ChMx'
    ChannelMixer = b'ChnM'
    CineonFormat = b'SDPX'
    ClippingInfo = b'Clpo'
    ClippingPath = b'ClpP'
    CloneStampTool = b'ClTl'
    Color = b'Clr '
    ColorBalance = b'ClrB'
    ColorCorrection = b'ClrC'
    ColorPickerPrefs = b'Clrk'
    ColorSampler = b'ClSm'
    ColorStop = b'Clrt'
    Command = b'Cmnd'
    Curves = b'Crvs'
    CurvePoint = b'CrPt'
    CustomPalette = b'Cstl'
    CurvesAdjustment = b'CrvA'
    CustomPhosphors = b'CstP'
    CustomWhitePoint = b'CstW'
    DicomFormat = b'Dicm'
    DisplayPrefs = b'DspP'
    Document = b'Dcmn'
    DodgeTool = b'DdTl'
    DropShadow = b'DrSh'
    DuotoneInk = b'DtnI'
    DuotoneMode = b'DtnM'
    EPSGenericFormat = b'EPSG'
    EPSPICTPreview = b'EPSC'
    EPSTIFFPreview = b'EPST'
    Element = b'Elmn'
    Ellipse = b'Elps'
    EraserTool = b'ErTl'
    Export = b'Expr'
    FileInfo = b'FlIn'
    FileSavePrefs = b'FlSv'
    FlashPixFormat = b'FlsP'
    FontDesignAxes = b'FntD'
    Format = b'Fmt '
    FrameFX = b'FrFX'
    Contour = b'FxSc'
    GeneralPrefs = b'GnrP'
    GIF89aExport = b'GF89'
    GIFFormat = b'GFFr'
    GlobalAngle = b'gblA'
    Gradient = b'Grdn'
    GradientFill = b'Grdf'
    GradientMap = b'GdMp'
    GradientTool = b'GrTl'
    GraySetup = b'GrSt'
    Grayscale = b'Grsc'
    GrayscaleMode = b'Grys'
    Guide = b'Gd  '
    GuidesPrefs = b'GdPr'
    HalftoneScreen = b'HlfS'
    HalftoneSpec = b'Hlfp'
    HSBColor = b'HSBC'
    HSBColorMode = b'HSBM'
    HistoryBrushTool = b'HBTl'
    HistoryPrefs = b'CHsP'
    HistoryState = b'HstS'
    HueSatAdjustment = b'HStA'
    HueSatAdjustmentV2 = b'Hst2'
    HueSaturation = b'HStr'
    IFFFormat = b'IFFF'
    IllustratorPathsExport = b'IlsP'
    ImagePoint = b'ImgP'
    Import = b'Impr'
    IndexedColorMode = b'IndC'
    InkTransfer = b'InkT'
    InnerGlow = b'IrGl'
    InnerShadow = b'IrSh'
    InterfaceColor = b'IClr'
    Invert = b'Invr'
    JPEGFormat = b'JPEG'
    LabColor = b'LbCl'
    LabColorMode = b'LbCM'
    Layer = b'Lyr '
    LayerEffects = b'Lefx'
    LayerFXVisible = b'lfxv'
    Levels = b'Lvls'
    LevelsAdjustment = b'LvlA'
    LightSource = b'LghS'
    Line = b'Ln  '
    MacPaintFormat = b'McPn'
    MagicEraserTool = b'MgEr'
    MagicPoint = b'Mgcp'
    Mask = b'Msk '
    MenuItem = b'Mn  '
    Mode = b'Md  '
    MultichannelMode = b'MltC'
    ObsoleteTextLayer = b'TxLy'
    Null = b'null'
    Offset = b'Ofst'
    Opacity = b'Opac'
    OuterGlow = b'OrGl'
    PDFGenericFormat = b'PDFG'
    PICTFileFormat = b'PICF'
    PICTResourceFormat = b'PICR'
    PNGFormat = b'PNGF'
    PageSetup = b'PgSt'
    PaintbrushTool = b'PbTl'
    Path = b'Path'
    PathComponent = b'PaCm'
    PathPoint = b'Pthp'
    Pattern = b'PttR'
    PatternStampTool = b'PaTl'
    PencilTool = b'PcTl'
    Photoshop20Format = b'Pht2'
    Photoshop35Format = b'Pht3'
    PhotoshopDCS2Format = b'PhD2'
    PhotoshopDCSFormat = b'PhD1'
    PhotoshopEPSFormat = b'PhtE'
    PhotoshopPDFFormat = b'PhtP'
    Pixel = b'Pxel'
    PixelPaintFormat = b'PxlP'
    PluginPrefs = b'PlgP'
    Point = b'Pnt '
    Point16 = b'Pnt1'
    Polygon = b'Plgn'
    Posterize = b'Pstr'
    Preferences = b'GnrP'
    ProfileSetup = b'PrfS'
    Property = b'Prpr'
    Range = b'Rang'
    Rect16 = b'Rct1'
    RGBColor = b'RGBC'
    RGBColorMode = b'RGBM'
    RGBSetup = b'RGBt'
    RawFormat = b'Rw  '
    Rectangle = b'Rctn'
    SaturationTool = b'SrTl'
    ScitexCTFormat = b'Sctx'
    Selection = b'csel'
    SelectiveColor = b'SlcC'
    ShapingCurve = b'ShpC'
    SharpenTool = b'ShTl'
    SingleColumn = b'Sngc'
    SingleRow = b'Sngr'
    BackgroundEraserTool = b'SETl'
    SolidFill = b'SoFi'
    ArtHistoryBrushTool = b'ABTl'
    SmudgeTool = b'SmTl'
    Snapshot = b'SnpS'
    SpotColorChannel = b'SCch'
    Style = b'StyC'
    SubPath = b'Sbpl'
    TIFFFormat = b'TIFF'
    TargaFormat = b'TrgF'
    TextLayer = b'TxLr'
    TextStyle = b'TxtS'
    TextStyleRange = b'Txtt'
    Threshold = b'Thrs'
    Tool = b'Tool'
    TransferSpec = b'Trfp'
    TransferPoint = b'DtnP'
    TransparencyPrefs = b'TrnP'
    TransparencyStop = b'TrnS'
    UnitsPrefs = b'UntP'
    UnspecifiedColor = b'UnsC'
    Version = b'Vrsn'
    WebdavPrefs = b'Wdbv'
    XYYColor = b'XYYC'
    ChromeFX = b'ChFX'
    BackLight = b'BakL'
    FillFlash = b'FilF'
    ColorCast = b'ColC'


class Enum(bytes, _Enum):
    """
    Enum definitions extracted from PITerminology.h.

    See https://www.adobe.com/devnet/photoshop/sdk.html
    """
    Add = b'Add '
    AmountHigh = b'amHi'
    AmountLow = b'amLo'
    AmountMedium = b'amMd'
    AntiAliasNone = b'Anno'
    AntiAliasLow = b'AnLo'
    AntiAliasMedium = b'AnMd'
    AntiAliasHigh = b'AnHi'
    AntiAliasCrisp = b'AnCr'
    AntiAliasStrong = b'AnSt'
    AntiAliasSmooth = b'AnSm'
    AppleRGB = b'AppR'
    ASCII = b'ASCI'
    AskWhenOpening = b'AskW'
    Bicubic = b'Bcbc'
    Binary = b'Bnry'
    MonitorSetup = b'MntS'
    _16BitsPerPixel = b'16Bt'
    _1BitPerPixel = b'OnBt'
    _2BitsPerPixel = b'2Bts'
    _32BitsPerPixel = b'32Bt'
    _4BitsPerPixel = b'4Bts'
    _5000 = b'5000'
    _5500 = b'5500'
    _6500 = b'6500'
    _72Color = b'72Cl'
    _72Gray = b'72Gr'
    _7500 = b'7500'
    _8BitsPerPixel = b'EghB'
    _9300 = b'9300'
    A = b'A   '
    AbsColorimetric = b'AClr'
    ADSBottoms = b'AdBt'
    ADSCentersH = b'AdCH'
    ADSCentersV = b'AdCV'
    ADSHorizontal = b'AdHr'
    ADSLefts = b'AdLf'
    ADSRights = b'AdRg'
    ADSTops = b'AdTp'
    ADSVertical = b'AdVr'
    AboutApp = b'AbAp'
    Absolute = b'Absl'
    ActualPixels = b'ActP'
    Adaptive = b'Adpt'
    AdjustmentOptions = b'AdjO'
    AirbrushEraser = b'Arbs'
    All = b'Al  '
    Amiga = b'Amga'
    Angle = b'Angl'
    Any = b'Any '
    ApplyImage = b'AplI'
    AroundCenter = b'ArnC'
    Arrange = b'Arng'
    Ask = b'Ask '
    B = b'B   '
    Back = b'Back'
    Background = b'Bckg'
    BackgroundColor = b'BckC'
    Backward = b'Bckw'
    Behind = b'Bhnd'
    Best = b'Bst '
    Better = b'Dthb'
    Bilinear = b'Blnr'
    BitDepth1 = b'BD1 '
    BitDepth16 = b'BD16'
    BitDepth24 = b'BD24'
    BitDepth32 = b'BD32'
    BitDepth4 = b'BD4 '
    BitDepth8 = b'BD8 '
    BitDepthA1R5G5B5 = b'1565'
    BitDepthR5G6B5 = b'x565'
    BitDepthX4R4G4B4 = b'x444'
    BitDepthA4R4G4B4 = b'4444'
    BitDepthX8R8G8B8 = b'x888'
    Bitmap = b'Btmp'
    Black = b'Blck'
    BlackAndWhite = b'BanW'
    BlackBody = b'BlcB'
    Blacks = b'Blks'
    BlockEraser = b'Blk '
    Blast = b'Blst'
    Blocks = b'Blks'
    Blue = b'Bl  '
    Blues = b'Bls '
    Bottom = b'Bttm'
    BrushDarkRough = b'BrDR'
    BrushesAppend = b'BrsA'
    BrushesDefine = b'BrsD'
    BrushesDelete = b'Brsf'
    BrushesLoad = b'Brsd'
    BrushesNew = b'BrsN'
    BrushesOptions = b'BrsO'
    BrushesReset = b'BrsR'
    BrushesSave = b'Brsv'
    BrushLightRough = b'BrsL'
    BrushSimple = b'BrSm'
    BrushSize = b'BrsS'
    BrushSparkle = b'BrSp'
    BrushWideBlurry = b'BrbW'
    BrushWideSharp = b'BrsW'
    Builtin = b'Bltn'
    BurnInH = b'BrnH'
    BurnInM = b'BrnM'
    BurnInS = b'BrnS'
    ButtonMode = b'BtnM'
    CIERGB = b'CRGB'
    WidePhosphors = b'Wide'
    WideGamutRGB = b'WRGB'
    CMYK = b'CMYK'
    CMYK64 = b'CMSF'
    CMYKColor = b'ECMY'
    Calculations = b'Clcl'
    Cascade = b'Cscd'
    Center = b'Cntr'
    CenterGlow = b'SrcC'
    CenteredFrame = b'CtrF'
    ChannelOptions = b'ChnO'
    ChannelsPaletteOptions = b'ChnP'
    CheckerboardNone = b'ChcN'
    CheckerboardSmall = b'ChcS'
    CheckerboardMedium = b'ChcM'
    CheckerboardLarge = b'ChcL'
    Clear = b'Clar'
    ClearGuides = b'ClrG'
    Clipboard = b'Clpb'
    ClippingPath = b'ClpP'
    CloseAll = b'ClsA'
    CoarseDots = b'CrsD'
    Color = b'Clr '
    ColorBurn = b'CBrn'
    ColorDodge = b'CDdg'
    ColorMatch = b'ClMt'
    ColorNoise = b'ClNs'
    Colorimetric = b'Clrm'
    Composite = b'Cmps'
    ConvertToCMYK = b'CnvC'
    ConvertToGray = b'CnvG'
    ConvertToLab = b'CnvL'
    ConvertToRGB = b'CnvR'
    CreateDuplicate = b'CrtD'
    CreateInterpolation = b'CrtI'
    Cross = b'Crs '
    CurrentLayer = b'CrrL'
    Custom = b'Cst '
    CustomPattern = b'Cstm'
    CustomStops = b'CstS'
    Cyan = b'Cyn '
    Cyans = b'Cyns'
    Dark = b'Drk '
    Darken = b'Drkn'
    DarkenOnly = b'DrkO'
    DashedLines = b'DshL'
    Desaturate = b'Dstt'
    Diamond = b'Dmnd'
    Difference = b'Dfrn'
    Diffusion = b'Dfsn'
    DiffusionDither = b'DfnD'
    DisplayCursorsPreferences = b'DspC'
    Dissolve = b'Dslv'
    Distort = b'Dstr'
    DodgeH = b'DdgH'
    DodgeM = b'DdgM'
    DodgeS = b'DdgS'
    Dots = b'Dts '
    Draft = b'Drft'
    Duotone = b'Dtn '
    EBUITU = b'EBT '
    EdgeGlow = b'SrcE'
    EliminateEvenFields = b'ElmE'
    EliminateOddFields = b'ElmO'
    Ellipse = b'Elps'
    Emboss = b'Embs'
    Exact = b'Exct'
    Exclusion = b'Xclu'
    FPXCompressLossyJPEG = b'FxJP'
    FPXCompressNone = b'FxNo'
    Faster = b'Dthf'
    File = b'Fle '
    FileInfo = b'FlIn'
    FillBack = b'FlBc'
    FillFore = b'FlFr'
    FillInverse = b'FlIn'
    FillSame = b'FlSm'
    FineDots = b'FnDt'
    First = b'Frst'
    FirstIdle = b'FrId'
    FitOnScreen = b'FtOn'
    ForegroundColor = b'FrgC'
    Forward = b'Frwr'
    FreeTransform = b'FrTr'
    Front = b'Frnt'
    FullDocument = b'FllD'
    FullSize = b'FlSz'
    GaussianDistribution = b'Gsn '
    GIFColorFileColorTable = b'GFCT'
    GIFColorFileColors = b'GFCF'
    GIFColorFileMicrosoftPalette = b'GFMS'
    GIFPaletteAdaptive = b'GFPA'
    GIFPaletteExact = b'GFPE'
    GIFPaletteOther = b'GFPO'
    GIFPaletteSystem = b'GFPS'
    GIFRequiredColorSpaceIndexed = b'GFCI'
    GIFRequiredColorSpaceRGB = b'GFRG'
    GIFRowOrderInterlaced = b'GFIN'
    GIFRowOrderNormal = b'GFNI'
    GeneralPreferences = b'GnrP'
    Good = b'Gd  '
    GradientFill = b'GrFl'
    GrainClumped = b'GrnC'
    GrainContrasty = b'GrCn'
    GrainEnlarged = b'GrnE'
    GrainHorizontal = b'GrnH'
    GrainRegular = b'GrnR'
    GrainSoft = b'GrSf'
    GrainSpeckle = b'GrSp'
    GrainSprinkles = b'GrSr'
    GrainStippled = b'GrSt'
    GrainVertical = b'GrnV'
    GrainyDots = b'GrnD'
    Graphics = b'Grp '
    Gray = b'Gry '
    Gray16 = b'GryX'
    Gray18 = b'Gr18'
    Gray22 = b'Gr22'
    Gray50 = b'Gr50'
    GrayScale = b'Gryc'
    Grayscale = b'Grys'
    Green = b'Grn '
    Greens = b'Grns'
    GuidesGridPreferences = b'GudG'
    HDTV = b'HDTV'
    HSBColor = b'HSBl'
    HSLColor = b'HSLC'
    HalftoneFile = b'HlfF'
    HalftoneScreen = b'HlfS'
    HardLight = b'HrdL'
    Heavy = b'Hvy '
    HideAll = b'HdAl'
    HideSelection = b'HdSl'
    High = b'High'
    HighQuality = b'Hgh '
    Highlights = b'Hghl'
    Histogram = b'Hstg'
    History = b'Hsty'
    HistoryPaletteOptions = b'HstO'
    HistoryPreferences = b'HstP'
    Horizontal = b'Hrzn'
    HorizontalOnly = b'HrzO'
    Hue = b'H   '
    IBMPC = b'IBMP'
    ICC = b'ICC '
    Icon = b'Icn '
    IdleVM = b'IdVM'
    Ignore = b'Ignr'
    Image = b'Img '
    ImageCachePreferences = b'ImgP'
    IndexedColor = b'Indl'
    InfoPaletteOptions = b'InfP'
    InfoPaletteToggleSamplers = b'InfT'
    InnerBevel = b'InrB'
    InsetFrame = b'InsF'
    Inside = b'Insd'
    JPEG = b'JPEG'
    JustifyAll = b'JstA'
    JustifyFull = b'JstF'
    KeepProfile = b'KPro'
    KeyboardPreferences = b'KybP'
    Lab = b'Lab '
    Lab48 = b'LbCF'
    LabColor = b'LbCl'
    Large = b'Lrg '
    Last = b'Lst '
    LastFilter = b'LstF'
    LayerOptions = b'LyrO'
    LayersPaletteOptions = b'LyrP'
    Left = b'Left'
    Left_PLUGIN = b'Lft '
    LevelBased = b'LvlB'
    Light = b'Lgt '
    LightBlue = b'LgtB'
    LightDirBottom = b'LDBt'
    LightDirBottomLeft = b'LDBL'
    LightDirBottomRight = b'LDBR'
    LightDirLeft = b'LDLf'
    LightDirRight = b'LDRg'
    LightDirTop = b'LDTp'
    LightDirTopLeft = b'LDTL'
    LightDirTopRight = b'LDTR'
    LightGray = b'LgtG'
    LightDirectional = b'LghD'
    LightenOnly = b'LghO'
    LightOmni = b'LghO'
    LightPosBottom = b'LPBt'
    LightPosBottomLeft = b'LPBL'
    LightPosBottomRight = b'LPBr'
    LightPosLeft = b'LPLf'
    LightPosRight = b'LPRg'
    LightPosTop = b'LPTp'
    LightPosTopLeft = b'LPTL'
    LightPosTopRight = b'LPTR'
    LightRed = b'LgtR'
    LightSpot = b'LghS'
    Lighten = b'Lghn'
    Lightness = b'Lght'
    Line = b'Ln  '
    Lines = b'Lns '
    Linear = b'Lnr '
    Linked = b'Lnkd'
    LongLines = b'LngL'
    LongStrokes = b'LngS'
    Low = b'Low '
    Lower = b'Lwr '
    LowQuality = b'Lw  '
    Luminosity = b'Lmns'
    Maya = b'Maya'
    MacThumbnail = b'McTh'
    Macintosh = b'Mcnt'
    MacintoshSystem = b'McnS'
    Magenta = b'Mgnt'
    Magentas = b'Mgnt'
    Mask = b'Msk '
    MaskedAreas = b'MskA'
    MasterAdaptive = b'MAdp'
    MasterPerceptual = b'MPer'
    MasterSelective = b'MSel'
    Maximum = b'Mxmm'
    MaximumQuality = b'Mxm '
    Medium = b'Mdim'
    MediumBlue = b'MdmB'
    MediumQuality = b'Mdm '
    MediumDots = b'MdmD'
    MediumLines = b'MdmL'
    MediumStrokes = b'MdmS'
    MemoryPreferences = b'MmrP'
    MergeChannels = b'MrgC'
    Merged = b'Mrgd'
    MergedLayers = b'Mrg2'
    MergedLayersOld = b'MrgL'
    Middle = b'Mddl'
    Midtones = b'Mdtn'
    ModeGray = b'MdGr'
    ModeRGB = b'MdRG'
    Monitor = b'Moni'
    Monotone = b'Mntn'
    Multi72Color = b'72CM'
    Multi72Gray = b'72GM'
    Multichannel = b'Mlth'
    MultiNoCompositePS = b'NCmM'
    Multiply = b'Mltp'
    NavigatorPaletteOptions = b'NvgP'
    NearestNeighbor = b'Nrst'
    NetscapeGray = b'NsGr'
    Neutrals = b'Ntrl'
    NewView = b'NwVw'
    Next = b'Nxt '
    Nikon = b'Nkn '
    Nikon105 = b'Nkn1'
    No = b'N   '
    NoCompositePS = b'NCmp'
    _None = b'None'
    Normal = b'Nrml'
    NormalPath = b'NrmP'
    NTSC = b'NTSC'
    Null = b'null'
    OS2 = b'OS2 '
    Off = b'Off '
    On = b'On  '
    OpenAs = b'OpAs'
    Orange = b'Orng'
    OutFromCenter = b'OtFr'
    OutOfGamut = b'OtOf'
    OuterBevel = b'OtrB'
    Outside = b'Otsd'
    OutsetFrame = b'OutF'
    Overlay = b'Ovrl'
    PaintbrushEraser = b'Pntb'
    PencilEraser = b'Pncl'
    P22EBU = b'P22B'
    PNGFilterAdaptive = b'PGAd'
    PNGFilterAverage = b'PGAv'
    PNGFilterNone = b'PGNo'
    PNGFilterPaeth = b'PGPt'
    PNGFilterSub = b'PGSb'
    PNGFilterUp = b'PGUp'
    PNGInterlaceAdam7 = b'PGIA'
    PNGInterlaceNone = b'PGIN'
    PagePosCentered = b'PgPC'
    PagePosTopLeft = b'PgTL'
    PageSetup = b'PgSt'
    PalSecam = b'PlSc'
    PanaVision = b'PnVs'
    PathsPaletteOptions = b'PthP'
    Pattern = b'Ptrn'
    PatternDither = b'PtnD'
    Perceptual = b'Perc'
    Perspective = b'Prsp'
    PhotoshopPicker = b'Phtk'
    PickCMYK = b'PckC'
    PickGray = b'PckG'
    PickHSB = b'PckH'
    PickLab = b'PckL'
    PickOptions = b'PckO'
    PickRGB = b'PckR'
    PillowEmboss = b'PlEb'
    PixelPaintSize1 = b'PxS1'
    PixelPaintSize2 = b'PxS2'
    PixelPaintSize3 = b'PxS3'
    PixelPaintSize4 = b'PxS4'
    Place = b'Plce'
    PlaybackOptions = b'PbkO'
    PluginPicker = b'PlgP'
    PluginsScratchDiskPreferences = b'PlgS'
    PolarToRect = b'PlrR'
    PondRipples = b'PndR'
    Precise = b'Prc '
    PreciseMatte = b'PrBL'
    PreviewOff = b'PrvO'
    PreviewCMYK = b'PrvC'
    PreviewCyan = b'Prvy'
    PreviewMagenta = b'PrvM'
    PreviewYellow = b'PrvY'
    PreviewBlack = b'PrvB'
    PreviewCMY = b'PrvN'
    Previous = b'Prvs'
    Primaries = b'Prim'
    PrintSize = b'PrnS'
    PrintingInksSetup = b'PrnI'
    Purple = b'Prp '
    Pyramids = b'Pyrm'
    QCSAverage = b'Qcsa'
    QCSCorner0 = b'Qcs0'
    QCSCorner1 = b'Qcs1'
    QCSCorner2 = b'Qcs2'
    QCSCorner3 = b'Qcs3'
    QCSIndependent = b'Qcsi'
    QCSSide0 = b'Qcs4'
    QCSSide1 = b'Qcs5'
    QCSSide2 = b'Qcs6'
    QCSSide3 = b'Qcs7'
    Quadtone = b'Qdtn'
    QueryAlways = b'QurA'
    QueryAsk = b'Qurl'
    QueryNever = b'QurN'
    Repeat = b'Rpt '
    RGB = b'RGB '
    RGB48 = b'RGBF'
    RGBColor = b'RGBC'
    Radial = b'Rdl '
    Random = b'Rndm'
    RectToPolar = b'RctP'
    Red = b'Rd  '
    RedrawComplete = b'RdCm'
    Reds = b'Rds '
    Reflected = b'Rflc'
    Relative = b'Rltv'
    RepeatEdgePixels = b'RptE'
    RevealAll = b'RvlA'
    RevealSelection = b'RvlS'
    Revert = b'Rvrt'
    Right = b'Rght'
    Rotate = b'Rtte'
    RotoscopingPreferences = b'RtsP'
    Round = b'Rnd '
    RulerCm = b'RrCm'
    RulerInches = b'RrIn'
    RulerPercent = b'RrPr'
    RulerPicas = b'RrPi'
    RulerPixels = b'RrPx'
    RulerPoints = b'RrPt'
    AdobeRGB1998 = b'SMPT'
    SMPTEC = b'SMPC'
    SRGB = b'SRGB'
    Sample3x3 = b'Smp3'
    Sample5x5 = b'Smp5'
    SamplePoint = b'SmpP'
    Saturate = b'Str '
    Saturation = b'Strt'
    Saved = b'Sved'
    SaveForWeb = b'Svfw'
    SavingFilesPreferences = b'SvnF'
    Scale = b'Scl '
    Screen = b'Scrn'
    ScreenCircle = b'ScrC'
    ScreenDot = b'ScrD'
    ScreenLine = b'ScrL'
    SelectedAreas = b'SlcA'
    Selection = b'Slct'
    Selective = b'Sele'
    SeparationSetup = b'SprS'
    SeparationTables = b'SprT'
    Shadows = b'Shdw'
    ContourLinear = b'sp01'
    ContourGaussian = b'sp02'
    ContourSingle = b'sp03'
    ContourDouble = b'sp04'
    ContourTriple = b'sp05'
    ContourCustom = b'sp06'
    ShortLines = b'ShrL'
    ShortStrokes = b'ShSt'
    Single72Color = b'72CS'
    Single72Gray = b'72GS'
    SingleNoCompositePS = b'NCmS'
    Skew = b'Skew'
    SlopeLimitMatte = b'Slmt'
    Small = b'Sml '
    SmartBlurModeEdgeOnly = b'SBME'
    SmartBlurModeNormal = b'SBMN'
    SmartBlurModeOverlayEdge = b'SBMO'
    SmartBlurQualityHigh = b'SBQH'
    SmartBlurQualityLow = b'SBQL'
    SmartBlurQualityMedium = b'SBQM'
    Snapshot = b'Snps'
    SolidColor = b'SClr'
    SoftLight = b'SftL'
    SoftMatte = b'SfBL'
    Spectrum = b'Spct'
    Spin = b'Spn '
    SpotColor = b'Spot'
    Square = b'Sqr '
    Stagger = b'Stgr'
    StampIn = b'In  '
    StampOut = b'Out '
    Standard = b'Std '
    StdA = b'StdA'
    StdB = b'StdB'
    StdC = b'StdC'
    StdE = b'StdE'
    StretchToFit = b'StrF'
    StrokeDirHorizontal = b'SDHz'
    StrokeDirLeftDiag = b'SDLD'
    StrokeDirRightDiag = b'SDRD'
    StrokeDirVertical = b'SDVt'
    StylesAppend = b'SlsA'
    StylesDelete = b'Slsf'
    StylesLoad = b'Slsd'
    StylesNew = b'SlsN'
    StylesReset = b'SlsR'
    StylesSave = b'Slsv'
    Subtract = b'Sbtr'
    SwatchesAppend = b'SwtA'
    SwatchesReplace = b'Swtp'
    SwatchesReset = b'SwtR'
    SwatchesSave = b'SwtS'
    SystemPicker = b'SysP'
    Tables = b'Tbl '
    Target = b'Trgt'
    TargetPath = b'Trgp'
    TexTypeBlocks = b'TxBl'
    TexTypeBrick = b'TxBr'
    TexTypeBurlap = b'TxBu'
    TexTypeCanvas = b'TxCa'
    TexTypeFrosted = b'TxFr'
    TexTypeSandstone = b'TxSt'
    TexTypeTinyLens = b'TxTL'
    Threshold = b'Thrh'
    Thumbnail = b'Thmb'
    TIFF = b'TIFF'
    Tile = b'Tile'
    Tile_PLUGIN = b'Tl  '
    ToggleActionsPalette = b'TglA'
    ToggleBlackPreview = b'TgBP'
    ToggleBrushesPalette = b'TglB'
    ToggleCMYKPreview = b'TglC'
    ToggleCMYPreview = b'TgCM'
    ToggleChannelsPalette = b'Tglh'
    ToggleColorPalette = b'Tglc'
    ToggleCyanPreview = b'TgCP'
    ToggleEdges = b'TglE'
    ToggleGamutWarning = b'TglG'
    ToggleGrid = b'TgGr'
    ToggleGuides = b'Tgld'
    ToggleHistoryPalette = b'TglH'
    ToggleInfoPalette = b'TglI'
    ToggleLayerMask = b'TglM'
    ToggleLayersPalette = b'Tgly'
    ToggleLockGuides = b'TglL'
    ToggleMagentaPreview = b'TgMP'
    ToggleNavigatorPalette = b'TglN'
    ToggleOptionsPalette = b'TglO'
    TogglePaths = b'TglP'
    TogglePathsPalette = b'Tglt'
    ToggleRGBMacPreview = b'TrMp'
    ToggleRGBWindowsPreview = b'TrWp'
    ToggleRGBUncompensatedPreview = b'TrUp'
    ToggleRulers = b'TglR'
    ToggleSnapToGrid = b'TgSn'
    ToggleSnapToGuides = b'TglS'
    ToggleStatusBar = b'Tgls'
    ToggleStylesPalette = b'TgSl'
    ToggleSwatchesPalette = b'Tglw'
    ToggleToolsPalette = b'TglT'
    ToggleYellowPreview = b'TgYP'
    ToggleDocumentPalette = b'TgDc'
    Top = b'Top '
    Transparency = b'Trsp'
    TransparencyGamutPreferences = b'TrnG'
    Transparent = b'Trns'
    Trinitron = b'Trnt'
    Tritone = b'Trtn'
    UIBitmap = b'UBtm'
    UICMYK = b'UCMY'
    UIDuotone = b'UDtn'
    UIGrayscale = b'UGry'
    UIIndexed = b'UInd'
    UILab = b'ULab'
    UIMultichannel = b'UMlt'
    UIRGB = b'URGB'
    Undo = b'Und '
    Uniform = b'Unfm'
    UniformDistribution = b'Unfr'
    UnitsRulersPreferences = b'UntR'
    Upper = b'Upr '
    UserStop = b'UsrS'
    VMPreferences = b'VMPr'
    Vertical = b'Vrtc'
    VerticalOnly = b'VrtO'
    Violet = b'Vlt '
    WaveSine = b'WvSn'
    WaveSquare = b'WvSq'
    WaveTriangle = b'WvTr'
    Web = b'Web '
    White = b'Wht '
    Whites = b'Whts'
    WinThumbnail = b'WnTh'
    Wind = b'Wnd '
    Windows = b'Win '
    WindowsSystem = b'WndS'
    Wrap = b'Wrp '
    WrapAround = b'WrpA'
    WorkPath = b'WrkP'
    Yellow = b'Yllw'
    YellowColor = b'Ylw '
    Yellows = b'Ylws'
    Yes = b'Ys  '
    Zip = b'ZpEn'
    Zoom = b'Zm  '
    ZoomIn = b'ZmIn'
    ZoomOut = b'ZmOt'


class Event(bytes, _Enum):
    """
    Event definitions extracted from PITerminology.h.

    See https://www.adobe.com/devnet/photoshop/sdk.html
    """
    _3DTransform = b'TdT '
    Average = b'Avrg'
    ApplyStyle = b'ASty'
    Assert = b'Asrt'
    AccentedEdges = b'AccE'
    Add = b'Add '
    AddNoise = b'AdNs'
    AddTo = b'AddT'
    Align = b'Algn'
    All = b'All '
    AngledStrokes = b'AngS'
    ApplyImage = b'AppI'
    BasRelief = b'BsRl'
    Batch = b'Btch'
    BatchFromDroplet = b'BtcF'
    Blur = b'Blr '
    BlurMore = b'BlrM'
    Border = b'Brdr'
    Brightness = b'BrgC'
    CanvasSize = b'CnvS'
    ChalkCharcoal = b'ChlC'
    ChannelMixer = b'ChnM'
    Charcoal = b'Chrc'
    Chrome = b'Chrm'
    Clear = b'Cler'
    Close = b'Cls '
    Clouds = b'Clds'
    ColorBalance = b'ClrB'
    ColorHalftone = b'ClrH'
    ColorRange = b'ClrR'
    ColoredPencil = b'ClrP'
    ConteCrayon = b'CntC'
    Contract = b'Cntc'
    ConvertMode = b'CnvM'
    Copy = b'copy'
    CopyEffects = b'CpFX'
    CopyMerged = b'CpyM'
    CopyToLayer = b'CpTL'
    Craquelure = b'Crql'
    CreateDroplet = b'CrtD'
    Crop = b'Crop'
    Crosshatch = b'Crsh'
    Crystallize = b'Crst'
    Curves = b'Crvs'
    Custom = b'Cstm'
    Cut = b'cut '
    CutToLayer = b'CtTL'
    Cutout = b'Ct  '
    DarkStrokes = b'DrkS'
    DeInterlace = b'Dntr'
    DefinePattern = b'DfnP'
    Defringe = b'Dfrg'
    Delete = b'Dlt '
    Desaturate = b'Dstt'
    Deselect = b'Dslc'
    Despeckle = b'Dspc'
    DifferenceClouds = b'DfrC'
    Diffuse = b'Dfs '
    DiffuseGlow = b'DfsG'
    DisableLayerFX = b'dlfx'
    Displace = b'Dspl'
    Distribute = b'Dstr'
    Draw = b'Draw'
    DryBrush = b'DryB'
    Duplicate = b'Dplc'
    DustAndScratches = b'DstS'
    Emboss = b'Embs'
    Equalize = b'Eqlz'
    Exchange = b'Exch'
    Expand = b'Expn'
    Export = b'Expr'
    Extrude = b'Extr'
    Facet = b'Fct '
    Fade = b'Fade'
    Feather = b'Fthr'
    Fibers = b'Fbrs'
    Fill = b'Fl  '
    FilmGrain = b'FlmG'
    Filter = b'Fltr'
    FindEdges = b'FndE'
    FlattenImage = b'FltI'
    Flip = b'Flip'
    Fragment = b'Frgm'
    Fresco = b'Frsc'
    GaussianBlur = b'GsnB'
    Get = b'getd'
    Glass = b'Gls '
    GlowingEdges = b'GlwE'
    Gradient = b'Grdn'
    GradientMap = b'GrMp'
    Grain = b'Grn '
    GraphicPen = b'GraP'
    Group = b'GrpL'
    Grow = b'Grow'
    HalftoneScreen = b'HlfS'
    Hide = b'Hd  '
    HighPass = b'HghP'
    HSBHSL = b'HsbP'
    HueSaturation = b'HStr'
    ImageSize = b'ImgS'
    Import = b'Impr'
    InkOutlines = b'InkO'
    Intersect = b'Intr'
    IntersectWith = b'IntW'
    Inverse = b'Invs'
    Invert = b'Invr'
    LensFlare = b'LnsF'
    Levels = b'Lvls'
    LightingEffects = b'LghE'
    Link = b'Lnk '
    Make = b'Mk  '
    Maximum = b'Mxm '
    Median = b'Mdn '
    MergeLayers = b'Mrg2'
    MergeLayersOld = b'MrgL'
    MergeSpotChannel = b'MSpt'
    MergeVisible = b'MrgV'
    Mezzotint = b'Mztn'
    Minimum = b'Mnm '
    Mosaic = b'Msc '
    Mosaic_PLUGIN = b'MscT'
    MotionBlur = b'MtnB'
    Move = b'move'
    NTSCColors = b'NTSC'
    NeonGlow = b'NGlw'
    Next = b'Nxt '
    NotePaper = b'NtPr'
    Notify = b'Ntfy'
    Null = b'null'
    OceanRipple = b'OcnR'
    Offset = b'Ofst'
    Open = b'Opn '
    PaintDaubs = b'PntD'
    PaletteKnife = b'PltK'
    Paste = b'past'
    PasteEffects = b'PaFX'
    PasteInto = b'PstI'
    PasteOutside = b'PstO'
    Patchwork = b'Ptch'
    Photocopy = b'Phtc'
    Pinch = b'Pnch'
    Place = b'Plc '
    Plaster = b'Plst'
    PlasticWrap = b'PlsW'
    Play = b'Ply '
    Pointillize = b'Pntl'
    Polar = b'Plr '
    PosterEdges = b'PstE'
    Posterize = b'Pstr'
    Previous = b'Prvs'
    Print = b'Prnt'
    ProfileToProfile = b'PrfT'
    Purge = b'Prge'
    Quit = b'quit'
    RadialBlur = b'RdlB'
    Rasterize = b'Rstr'
    RasterizeTypeSheet = b'RstT'
    RemoveBlackMatte = b'RmvB'
    RemoveLayerMask = b'RmvL'
    RemoveWhiteMatte = b'RmvW'
    Rename = b'Rnm '
    ReplaceColor = b'RplC'
    Reset = b'Rset'
    Reticulation = b'Rtcl'
    Revert = b'Rvrt'
    Ripple = b'Rple'
    Rotate = b'Rtte'
    RoughPastels = b'RghP'
    Save = b'save'
    Select = b'slct'
    SelectiveColor = b'SlcC'
    Set = b'setd'
    SharpenEdges = b'ShrE'
    Sharpen = b'Shrp'
    SharpenMore = b'ShrM'
    Shear = b'Shr '
    Show = b'Shw '
    Similar = b'Smlr'
    SmartBlur = b'SmrB'
    Smooth = b'Smth'
    SmudgeStick = b'SmdS'
    Solarize = b'Slrz'
    Spatter = b'Spt '
    Spherize = b'Sphr'
    SplitChannels = b'SplC'
    Sponge = b'Spng'
    SprayedStrokes = b'SprS'
    StainedGlass = b'StnG'
    Stamp = b'Stmp'
    Stop = b'Stop'
    Stroke = b'Strk'
    Subtract = b'Sbtr'
    SubtractFrom = b'SbtF'
    Sumie = b'Smie'
    TakeMergedSnapshot = b'TkMr'
    TakeSnapshot = b'TkSn'
    TextureFill = b'TxtF'
    Texturizer = b'Txtz'
    Threshold = b'Thrs'
    Tiles = b'Tls '
    TornEdges = b'TrnE'
    TraceContour = b'TrcC'
    Transform = b'Trnf'
    Trap = b'Trap'
    Twirl = b'Twrl'
    Underpainting = b'Undr'
    Undo = b'undo'
    Ungroup = b'Ungr'
    Unlink = b'Unlk'
    UnsharpMask = b'UnsM'
    Variations = b'Vrtn'
    Wait = b'Wait'
    WaterPaper = b'WtrP'
    Watercolor = b'Wtrc'
    Wave = b'Wave'
    Wind = b'Wnd '
    ZigZag = b'ZgZg'
    BackLight = b'BacL'
    ColorCast = b'ColE'
    OpenUntitled = b'OpnU'


class Form(bytes, _Enum):
    """
    Form definitions extracted from PITerminology.h.

    See https://www.adobe.com/devnet/photoshop/sdk.html
    """
    Class = b'Clss'
    Enumerated = b'Enmr'
    Identifier = b'Idnt'
    Index = b'indx'
    Offset = b'rele'
    Property = b'prop'


class Key(bytes, _Enum):
    """
    Key definitions extracted from PITerminology.h.

    See https://www.adobe.com/devnet/photoshop/sdk.html
    """
    _3DAntiAlias = b'Alis'
    A = b'A   '
    Adjustment = b'Adjs'
    Aligned = b'Algd'
    Alignment = b'Algn'
    AllPS = b'All '
    AllExcept = b'AllE'
    AllToolOptions = b'AlTl'
    AlphaChannelOptions = b'AChn'
    AlphaChannels = b'AlpC'
    AmbientBrightness = b'AmbB'
    AmbientColor = b'AmbC'
    Amount = b'Amnt'
    AmplitudeMax = b'AmMx'
    AmplitudeMin = b'AmMn'
    Anchor = b'Anch'
    Angle = b'Angl'
    Angle1 = b'Ang1'
    Angle2 = b'Ang2'
    Angle3 = b'Ang3'
    Angle4 = b'Ang4'
    AntiAlias = b'AntA'
    Append = b'Appe'
    Apply = b'Aply'
    Area = b'Ar  '
    Arrowhead = b'Arrw'
    As = b'As  '
    AssetBin = b'Asst'
    AssumedCMYK = b'AssC'
    AssumedGray = b'AssG'
    AssumedRGB = b'AssR'
    At = b'At  '
    Auto = b'Auto'
    AutoContrast = b'AuCo'
    AutoErase = b'Atrs'
    AutoKern = b'AtKr'
    AutoUpdate = b'AtUp'
    ShowMenuColors = b'SwMC'
    Axis = b'Axis'
    B = b'B   '
    Background = b'Bckg'
    BackgroundColor = b'BckC'
    BackgroundLevel = b'BckL'
    Backward = b'Bwd '
    Balance = b'Blnc'
    BaselineShift = b'Bsln'
    BeepWhenDone = b'BpWh'
    BeginRamp = b'BgnR'
    BeginSustain = b'BgnS'
    BevelDirection = b'bvlD'
    BevelEmboss = b'ebbl'
    BevelStyle = b'bvlS'
    BevelTechnique = b'bvlT'
    BigNudgeH = b'BgNH'
    BigNudgeV = b'BgNV'
    BitDepth = b'BtDp'
    Black = b'Blck'
    BlackClip = b'BlcC'
    BlackGeneration = b'Blcn'
    BlackGenerationCurve = b'BlcG'
    BlackIntensity = b'BlcI'
    BlackLevel = b'BlcL'
    BlackLimit = b'BlcL'
    Bleed = b'Bld '
    BlendRange = b'Blnd'
    Blue = b'Bl  '
    BlueBlackPoint = b'BlBl'
    BlueGamma = b'BlGm'
    BlueWhitePoint = b'BlWh'
    BlueX = b'BlX '
    BlueY = b'BlY '
    Blur = b'blur'
    BlurMethod = b'BlrM'
    BlurQuality = b'BlrQ'
    Book = b'Bk  '
    BorderThickness = b'BrdT'
    Bottom = b'Btom'
    Brightness = b'Brgh'
    BrushDetail = b'BrsD'
    Brushes = b'Brsh'
    BrushSize = b'BrsS'
    BrushType = b'BrsT'
    BumpAmplitude = b'BmpA'
    BumpChannel = b'BmpC'
    By = b'By  '
    Byline = b'Byln'
    BylineTitle = b'BylT'
    ByteOrder = b'BytO'
    CachePrefs = b'CchP'
    ChokeMatte = b'Ckmt'
    CloneSource = b'ClnS'
    CMYKSetup = b'CMYS'
    Calculation = b'Clcl'
    CalibrationBars = b'Clbr'
    Caption = b'Cptn'
    CaptionWriter = b'CptW'
    Category = b'Ctgr'
    CellSize = b'ClSz'
    Center = b'Cntr'
    CenterCropMarks = b'CntC'
    ChalkArea = b'ChlA'
    Channel = b'Chnl'
    ChannelMatrix = b'ChMx'
    ChannelName = b'ChnN'
    Channels = b'Chns'
    ChannelsInterleaved = b'ChnI'
    CharcoalAmount = b'ChAm'
    CharcoalArea = b'ChrA'
    ChromeFX = b'ChFX'
    City = b'City'
    ClearAmount = b'ClrA'
    ClippingPath = b'ClPt'
    ClippingPathEPS = b'ClpP'
    ClippingPathFlatness = b'ClpF'
    ClippingPathIndex = b'ClpI'
    ClippingPathInfo = b'Clpg'
    ClosedSubpath = b'Clsp'
    Color = b'Clr '
    ColorChannels = b'Clrh'
    ColorCorrection = b'ClrC'
    ColorIndicates = b'ClrI'
    ColorManagement = b'ClMg'
    ColorPickerPrefs = b'Clrr'
    ColorTable = b'ClrT'
    Colorize = b'Clrz'
    Colors = b'Clrs'
    ColorsList = b'ClrL'
    ColorSpace = b'ClrS'
    ColumnWidth = b'ClmW'
    CommandKey = b'CmdK'
    Compensation = b'Cmpn'
    Compression = b'Cmpr'
    Concavity = b'Cncv'
    Condition = b'Cndt'
    Constant = b'Cnst'
    Constrain = b'Cnst'
    ConstrainProportions = b'CnsP'
    ConstructionFOV = b'Cfov'
    Contiguous = b'Cntg'
    Continue = b'Cntn'
    Continuity = b'Cnty'
    Contrast = b'Cntr'
    Convert = b'Cnvr'
    Copy = b'Cpy '
    Copyright = b'Cpyr'
    CopyrightNotice = b'CprN'
    CornerCropMarks = b'CrnC'
    Count = b'Cnt '
    CountryName = b'CntN'
    CrackBrightness = b'CrcB'
    CrackDepth = b'CrcD'
    CrackSpacing = b'CrcS'
    CreateLayersFromLayerFX = b'blfl'
    Credit = b'Crdt'
    Crossover = b'Crss'
    Current = b'Crnt'
    CurrentHistoryState = b'CrnH'
    CurrentLight = b'CrnL'
    CurrentToolOptions = b'CrnT'
    Curve = b'Crv '
    CurveFile = b'CrvF'
    Custom = b'Cstm'
    CustomForced = b'CstF'
    CustomMatte = b'CstM'
    CustomPalette = b'CstP'
    Cyan = b'Cyn '
    DarkIntensity = b'DrkI'
    Darkness = b'Drkn'
    DateCreated = b'DtCr'
    Datum = b'Dt  '
    DCS = b'DCS '
    Definition = b'Dfnt'
    Density = b'Dnst'
    Depth = b'Dpth'
    DestBlackMax = b'Dstl'
    DestBlackMin = b'DstB'
    DestinationMode = b'DstM'
    DestWhiteMax = b'Dstt'
    DestWhiteMin = b'DstW'
    Detail = b'Dtl '
    Diameter = b'Dmtr'
    DiffusionDither = b'DffD'
    Direction = b'Drct'
    DirectionBalance = b'DrcB'
    DisplaceFile = b'DspF'
    DisplacementMap = b'DspM'
    DisplayPrefs = b'DspP'
    Distance = b'Dstn'
    Distortion = b'Dstr'
    Distribution = b'Dstr'
    Dither = b'Dthr'
    DitherAmount = b'DthA'
    DitherPreserve = b'Dthp'
    DitherQuality = b'Dthq'
    DocumentID = b'DocI'
    DotGain = b'DtGn'
    DotGainCurves = b'DtGC'
    DPXFormat = b'DPXf'
    DropShadow = b'DrSh'
    Duplicate = b'Dplc'
    DynamicColorSliders = b'DnmC'
    Edge = b'Edg '
    EdgeBrightness = b'EdgB'
    EdgeFidelity = b'EdgF'
    EdgeIntensity = b'EdgI'
    EdgeSimplicity = b'EdgS'
    EdgeThickness = b'EdgT'
    EdgeWidth = b'EdgW'
    Effect = b'Effc'
    EmbedProfiles = b'EmbP'
    EmbedCMYK = b'EmbC'
    EmbedGray = b'EmbG'
    EmbedLab = b'EmbL'
    EmbedRGB = b'EmbR'
    EmulsionDown = b'EmlD'
    Enabled = b'enab'
    EnableGestures = b'EGst'
    Encoding = b'Encd'
    End = b'End '
    EndArrowhead = b'EndA'
    EndRamp = b'EndR'
    EndSustain = b'EndS'
    Engine = b'Engn'
    EraserKind = b'ErsK'
    EraseToHistory = b'ErsT'
    ExactPoints = b'ExcP'
    Export = b'Expr'
    ExportClipboard = b'ExpC'
    Exposure = b'Exps'
    Extend = b'Extd'
    Extension = b'Extn'
    ExtensionsQuery = b'ExtQ'
    ExtrudeDepth = b'ExtD'
    ExtrudeMaskIncomplete = b'ExtM'
    ExtrudeRandom = b'ExtR'
    ExtrudeSize = b'ExtS'
    ExtrudeSolidFace = b'ExtF'
    ExtrudeType = b'ExtT'
    EyeDropperSample = b'EyDr'
    FadeoutSteps = b'FdtS'
    FadeTo = b'FdT '
    Falloff = b'FlOf'
    FPXCompress = b'FxCm'
    FPXQuality = b'FxQl'
    FPXSize = b'FxSz'
    FPXView = b'FxVw'
    Feather = b'Fthr'
    FiberLength = b'FbrL'
    File = b'File'
    FileCreator = b'FlCr'
    FileInfo = b'FlIn'
    FileReference = b'FilR'
    FileSavePrefs = b'FlSP'
    FilesList = b'flst'
    FileType = b'FlTy'
    Fill = b'Fl  '
    FillColor = b'FlCl'
    FillNeutral = b'FlNt'
    FilterLayerRandomSeed = b'FlRs'
    FilterLayerPersistentData = b'FlPd'
    Fingerpainting = b'Fngr'
    FlareCenter = b'FlrC'
    Flatness = b'Fltn'
    Flatten = b'Fltt'
    FlipVertical = b'FlpV'
    Focus = b'Fcs '
    Folders = b'Fldr'
    FontDesignAxes = b'FntD'
    FontDesignAxesVectors = b'FntV'
    FontName = b'FntN'
    FontScript = b'Scrp'
    FontStyleName = b'FntS'
    FontTechnology = b'FntT'
    ForcedColors = b'FrcC'
    ForegroundColor = b'FrgC'
    ForegroundLevel = b'FrgL'
    Format = b'Fmt '
    Forward = b'Fwd '
    FrameFX = b'FrFX'
    FrameWidth = b'FrmW'
    FreeTransformCenterState = b'FTcs'
    Frequency = b'Frqn'
    From = b'From'
    FromBuiltin = b'FrmB'
    FromMode = b'FrmM'
    FunctionKey = b'FncK'
    Fuzziness = b'Fzns'
    GamutWarning = b'GmtW'
    GCR = b'GCR '
    GeneralPrefs = b'GnrP'
    GIFColorFileType = b'GFPT'
    GIFColorLimit = b'GFCL'
    GIFExportCaption = b'GFEC'
    GIFMaskChannelIndex = b'GFMI'
    GIFMaskChannelInverted = b'GFMV'
    GIFPaletteFile = b'GFPF'
    GIFPaletteType = b'GFPL'
    GIFRequiredColorSpaceType = b'GFCS'
    GIFRowOrderType = b'GFIT'
    GIFTransparentColor = b'GFTC'
    GIFTransparentIndexBlue = b'GFTB'
    GIFTransparentIndexGreen = b'GFTG'
    GIFTransparentIndexRed = b'GFTR'
    GIFUseBestMatch = b'GFBM'
    Gamma = b'Gmm '
    GlobalAngle = b'gblA'
    GlobalLightingAngle = b'gagl'
    Gloss = b'Glos'
    GlowAmount = b'GlwA'
    GlowTechnique = b'GlwT'
    Gradient = b'Grad'
    GradientFill = b'Grdf'
    Grain = b'Grn '
    GrainType = b'Grnt'
    Graininess = b'Grns'
    Gray = b'Gry '
    GrayBehavior = b'GrBh'
    GraySetup = b'GrSt'
    Green = b'Grn '
    GreenBlackPoint = b'GrnB'
    GreenGamma = b'GrnG'
    GreenWhitePoint = b'GrnW'
    GreenX = b'GrnX'
    GreenY = b'GrnY'
    GridColor = b'GrdC'
    GridCustomColor = b'Grds'
    GridMajor = b'GrdM'
    GridMinor = b'Grdn'
    GridStyle = b'GrdS'
    GridUnits = b'Grdt'
    Group = b'Grup'
    GroutWidth = b'GrtW'
    GrowSelection = b'GrwS'
    Guides = b'Gdes'
    GuidesColor = b'GdsC'
    GuidesCustomColor = b'Gdss'
    GuidesStyle = b'GdsS'
    GuidesPrefs = b'GdPr'
    GutterWidth = b'GttW'
    HalftoneFile = b'HlfF'
    HalftoneScreen = b'HlfS'
    HalftoneSpec = b'Hlfp'
    HalftoneSize = b'HlSz'
    Hardness = b'Hrdn'
    HasCmdHPreference = b'HCdH'
    Header = b'Hdr '
    Headline = b'Hdln'
    Height = b'Hght'
    HostName = b'HstN'
    HighlightArea = b'HghA'
    HighlightColor = b'hglC'
    HighlightLevels = b'HghL'
    HighlightMode = b'hglM'
    HighlightOpacity = b'hglO'
    HighlightStrength = b'HghS'
    HistoryBrushSource = b'HstB'
    HistoryPrefs = b'HstP'
    HistoryStateSource = b'HsSS'
    HistoryStates = b'HsSt'
    Horizontal = b'Hrzn'
    HorizontalScale = b'HrzS'
    HostVersion = b'HstV'
    Hue = b'H   '
    ICCEngine = b'ICCE'
    ICCSetupName = b'ICCt'
    ID = b'Idnt'
    Idle = b'Idle'
    ImageBalance = b'ImgB'
    Import = b'Impr'
    Impressionist = b'Imps'
    In = b'In  '
    Inherits = b'c@#^'
    InkColors = b'InkC'
    Inks = b'Inks'
    InnerGlow = b'IrGl'
    InnerGlowSource = b'glwS'
    InnerShadow = b'IrSh'
    Input = b'Inpt'
    InputBlackPoint = b'kIBP'
    InputMapRange = b'Inmr'
    InputRange = b'Inpr'
    InputWhitePoint = b'kIWP'
    Intensity = b'Intn'
    Intent = b'Inte'
    InterfaceBevelHighlight = b'IntH'
    InterfaceBevelShadow = b'Intv'
    InterfaceBlack = b'IntB'
    InterfaceBorder = b'Intd'
    InterfaceButtonDarkShadow = b'Intk'
    InterfaceButtonDownFill = b'Intt'
    InterfaceButtonUpFill = b'InBF'
    InterfaceColorBlue2 = b'ICBL'
    InterfaceColorBlue32 = b'ICBH'
    InterfaceColorGreen2 = b'ICGL'
    InterfaceColorGreen32 = b'ICGH'
    InterfaceColorRed2 = b'ICRL'
    InterfaceColorRed32 = b'ICRH'
    InterfaceIconFillActive = b'IntI'
    InterfaceIconFillDimmed = b'IntF'
    InterfaceIconFillSelected = b'Intc'
    InterfaceIconFrameActive = b'Intm'
    InterfaceIconFrameDimmed = b'Intr'
    InterfaceIconFrameSelected = b'IntS'
    InterfacePaletteFill = b'IntP'
    InterfaceRed = b'IntR'
    InterfaceWhite = b'IntW'
    InterfaceToolTipBackground = b'IntT'
    InterfaceToolTipText = b'ITTT'
    InterfaceTransparencyForeground = b'ITFg'
    InterfaceTransparencyBackground = b'ITBg'
    Interlace = b'Intr'
    InterlaceCreateType = b'IntC'
    InterlaceEliminateType = b'IntE'
    Interpolation = b'Intr'
    InterpolationMethod = b'IntM'
    Invert = b'Invr'
    InvertMask = b'InvM'
    InvertSource2 = b'InvS'
    InvertTexture = b'InvT'
    IsDirty = b'IsDr'
    ItemIndex = b'ItmI'
    JPEGQuality = b'JPEQ'
    Kerning = b'Krng'
    Keywords = b'Kywd'
    Kind = b'Knd '
    LZWCompression = b'LZWC'
    Labels = b'Lbls'
    Landscape = b'Lnds'
    LastTransform = b'LstT'
    LayerEffects = b'Lefx'
    LayerFXVisible = b'lfxv'
    Layer = b'Lyr '
    LayerID = b'LyrI'
    LayerName = b'LyrN'
    Layers = b'Lyrs'
    Leading = b'Ldng'
    Left = b'Left'
    Length = b'Lngt'
    TermLength = b'Lngt'
    Lens = b'Lns '
    Level = b'Lvl '
    Levels = b'Lvls'
    LightDark = b'LgDr'
    LightDirection = b'LghD'
    LightIntensity = b'LghI'
    LightPosition = b'LghP'
    LightSource = b'LghS'
    LightType = b'LghT'
    LightenGrout = b'LghG'
    Lightness = b'Lght'
    Line = b'Line'
    LinkedLayerIDs = b'LnkL'
    LocalLightingAngle = b'lagl'
    LocalLightingAltitude = b'Lald'
    LocalRange = b'LclR'
    Location = b'Lctn'
    Log = b'Log '
    Logarithmic = b'kLog'
    LowerCase = b'LwCs'
    Luminance = b'Lmnc'
    LUTAnimation = b'LTnm'
    Magenta = b'Mgnt'
    MakeVisible = b'MkVs'
    ManipulationFOV = b'Mfov'
    MapBlack = b'MpBl'
    Mapping = b'Mpng'
    MappingShape = b'MpgS'
    Material = b'Mtrl'
    Matrix = b'Mtrx'
    MatteColor = b'MttC'
    Maximum = b'Mxm '
    MaximumStates = b'MxmS'
    MemoryUsagePercent = b'MmrU'
    Merge = b'Mrge'
    Merged = b'Mrgd'
    Message = b'Msge'
    Method = b'Mthd'
    MezzotintType = b'MztT'
    Midpoint = b'Mdpn'
    MidtoneLevels = b'MdtL'
    Minimum = b'Mnm '
    MismatchCMYK = b'MsmC'
    MismatchGray = b'MsmG'
    MismatchRGB = b'MsmR'
    Mode = b'Md  '
    Monochromatic = b'Mnch'
    MoveTo = b'MvT '
    Name = b'Nm  '
    Negative = b'Ngtv'
    New = b'Nw  '
    Noise = b'Nose'
    NonImageData = b'NnIm'
    NonLinear = b'NnLn'
    Null = b'null'
    NumLights = b'Nm L'
    Number = b'Nmbr'
    NumberOfCacheLevels = b'NCch'
    NumberOfCacheLevels64 = b'NC64'
    NumberOfChannels = b'NmbO'
    NumberOfChildren = b'NmbC'
    NumberOfDocuments = b'NmbD'
    NumberOfGenerators = b'NmbG'
    NumberOfLayers = b'NmbL'
    NumberOfLevels = b'NmbL'
    NumberOfPaths = b'NmbP'
    NumberOfRipples = b'NmbR'
    NumberOfSiblings = b'NmbS'
    ObjectName = b'ObjN'
    Offset = b'Ofst'
    On = b'On  '
    Opacity = b'Opct'
    Optimized = b'Optm'
    Orientation = b'Ornt'
    OriginalHeader = b'OrgH'
    OriginalTransmissionReference = b'OrgT'
    OtherCursors = b'OthC'
    OuterGlow = b'OrGl'
    Output = b'Otpt'
    OutputBlackPoint = b'kOBP'
    OutputWhitePoint = b'kOWP'
    OverprintColors = b'OvrC'
    OverrideOpen = b'OvrO'
    OverridePrinter = b'ObrP'
    OverrideSave = b'Ovrd'
    PaintCursorKind = b'PnCK'
    ParentIndex = b'PrIn'
    ParentName = b'PrNm'
    PNGFilter = b'PNGf'
    PNGInterlaceType = b'PGIT'
    PageFormat = b'PMpf'
    PageNumber = b'PgNm'
    PageSetup = b'PgSt'
    PagePosition = b'PgPs'
    PaintingCursors = b'PntC'
    PaintType = b'PntT'
    Palette = b'Plt '
    PaletteFile = b'PltF'
    PaperBrightness = b'PprB'
    Path = b'Path'
    PathContents = b'PthC'
    PathName = b'PthN'
    Pattern = b'Pttn'
    PencilWidth = b'Pncl'
    PerspectiveIndex = b'Prsp'
    Phosphors = b'Phsp'
    PickerID = b'PckI'
    PickerKind = b'Pckr'
    PixelPaintSize = b'PPSz'
    Platform = b'Pltf'
    PluginFolder = b'PlgF'
    PluginPrefs = b'PlgP'
    Points = b'Pts '
    Position = b'Pstn'
    Posterization = b'Pstr'
    PostScriptColor = b'PstS'
    PredefinedColors = b'PrdC'
    PreferBuiltin = b'PrfB'
    PreserveAdditional = b'PrsA'
    PreserveLuminosity = b'PrsL'
    PreserveTransparency = b'PrsT'
    Pressure = b'Prs '
    Preferences = b'Prfr'
    Preview = b'Prvw'
    PreviewCMYK = b'PrvK'
    PreviewFullSize = b'PrvF'
    PreviewIcon = b'PrvI'
    PreviewMacThumbnail = b'PrvM'
    PreviewWinThumbnail = b'PrvW'
    PreviewsQuery = b'PrvQ'
    PrintSettings = b'PMps'
    ProfileSetup = b'PrfS'
    ProvinceState = b'PrvS'
    Quality = b'Qlty'
    ExtendedQuality = b'EQlt'
    QuickMask = b'QucM'
    RGBSetup = b'RGBS'
    Radius = b'Rds '
    RandomSeed = b'RndS'
    Ratio = b'Rt  '
    RecentFiles = b'Rcnf'
    Red = b'Rd  '
    RedBlackPoint = b'RdBl'
    RedGamma = b'RdGm'
    RedWhitePoint = b'RdWh'
    RedX = b'RdX '
    RedY = b'RdY '
    RegistrationMarks = b'RgsM'
    Relative = b'Rltv'
    Relief = b'Rlf '
    RenderFidelity = b'Rfid'
    Resample = b'Rsmp'
    ResizeWindowsOnZoom = b'RWOZ'
    Resolution = b'Rslt'
    ResourceID = b'RsrI'
    Response = b'Rspn'
    RetainHeader = b'RtnH'
    Reverse = b'Rvrs'
    Right = b'Rght'
    RippleMagnitude = b'RplM'
    RippleSize = b'RplS'
    Rotate = b'Rtt '
    Roundness = b'Rndn'
    RulerOriginH = b'RlrH'
    RulerOriginV = b'RlrV'
    RulerUnits = b'RlrU'
    Saturation = b'Strt'
    SaveAndClose = b'SvAn'
    SaveComposite = b'SvCm'
    SavePaletteLocations = b'PltL'
    SavePaths = b'SvPt'
    SavePyramids = b'SvPy'
    Saving = b'Svng'
    Scale = b'Scl '
    ScaleHorizontal = b'SclH'
    ScaleVertical = b'SclV'
    Scaling = b'Scln'
    Scans = b'Scns'
    ScratchDisks = b'ScrD'
    ScreenFile = b'ScrF'
    ScreenType = b'ScrT'
    ShadingIntensity = b'ShdI'
    ShadingNoise = b'ShdN'
    ShadingShape = b'ShdS'
    ContourType = b'ShpC'
    SerialString = b'SrlS'
    Separations = b'Sprt'
    ShadowColor = b'sdwC'
    ShadowIntensity = b'ShdI'
    ShadowLevels = b'ShdL'
    ShadowMode = b'sdwM'
    ShadowOpacity = b'sdwO'
    Shape = b'Shp '
    Sharpness = b'Shrp'
    ShearEd = b'ShrE'
    ShearPoints = b'ShrP'
    ShearSt = b'ShrS'
    ShiftKey = b'ShfK'
    ShiftKeyToolSwitch = b'ShKT'
    ShortNames = b'ShrN'
    ShowEnglishFontNames = b'ShwE'
    ShowToolTips = b'ShwT'
    ShowTransparency = b'ShTr'
    SizeKey = b'Sz  '
    Skew = b'Skew'
    SmartBlurMode = b'SmBM'
    SmartBlurQuality = b'SmBQ'
    Smooth = b'Smoo'
    Smoothness = b'Smth'
    SnapshotInitial = b'SnpI'
    SoftClip = b'SfCl'
    Softness = b'Sftn'
    SmallFontType = b'Sfts'
    OldSmallFontType = b'Sftt'
    SolidFill = b'SoFi'
    Source = b'Srce'
    Source2 = b'Src2'
    SourceMode = b'SrcM'
    Spacing = b'Spcn'
    SpecialInstructions = b'SpcI'
    SpherizeMode = b'SphM'
    Spot = b'Spot'
    SprayRadius = b'SprR'
    SquareSize = b'SqrS'
    SrcBlackMax = b'Srcl'
    SrcBlackMin = b'SrcB'
    SrcWhiteMax = b'Srcm'
    SrcWhiteMin = b'SrcW'
    Start = b'Strt'
    StartArrowhead = b'StrA'
    State = b'Stte'
    Strength = b'srgh'
    StrengthRatio = b'srgR'
    Strength_PLUGIN = b'Strg'
    StrokeDetail = b'StDt'
    StrokeDirection = b'SDir'
    StrokeLength = b'StrL'
    StrokePressure = b'StrP'
    StrokeSize = b'StrS'
    StrokeWidth = b'StrW'
    Style = b'Styl'
    Styles = b'Stys'
    StylusIsPressure = b'StlP'
    StylusIsColor = b'StlC'
    StylusIsOpacity = b'StlO'
    StylusIsSize = b'StlS'
    SubPathList = b'SbpL'
    SupplementalCategories = b'SplC'
    SystemInfo = b'SstI'
    SystemPalette = b'SstP'
    Target = b'null'
    TargetPath = b'Trgp'
    TargetPathIndex = b'TrgP'
    Text = b'Txt '
    TextClickPoint = b'TxtC'
    TextData = b'TxtD'
    TextStyle = b'TxtS'
    TextStyleRange = b'Txtt'
    Texture = b'Txtr'
    TextureCoverage = b'TxtC'
    TextureFile = b'TxtF'
    TextureType = b'TxtT'
    Threshold = b'Thsh'
    TileNumber = b'TlNm'
    TileOffset = b'TlOf'
    TileSize = b'TlSz'
    Title = b'Ttl '
    To = b'T   '
    ToBuiltin = b'TBl '
    ToLinked = b'ToLk'
    ToMode = b'TMd '
    ToggleOthers = b'TglO'
    Tolerance = b'Tlrn'
    Top = b'Top '
    TotalLimit = b'TtlL'
    Tracking = b'Trck'
    TransferSpec = b'TrnS'
    TransparencyGrid = b'TrnG'
    TransferFunction = b'TrnF'
    Transparency = b'Trns'
    TransparencyGridColors = b'TrnC'
    TransparencyGridSize = b'TrnG'
    TransparencyPrefs = b'TrnP'
    TransparencyShape = b'TrnS'
    TransparentIndex = b'TrnI'
    TransparentWhites = b'TrnW'
    Twist = b'Twst'
    Type = b'Type'
    UCA = b'UC  '
    UnitsPrefs = b'UntP'
    URL = b'URL '
    UndefinedArea = b'UndA'
    Underline = b'Undl'
    Untitled = b'Untl'
    UpperY = b'UppY'
    Urgency = b'Urgn'
    UseAccurateScreens = b'AcrS'
    UseAdditionalPlugins = b'AdPl'
    UseCacheForHistograms = b'UsCc'
    UseCurves = b'UsCr'
    UseDefault = b'UsDf'
    UseGlobalAngle = b'uglg'
    UseICCProfile = b'UsIC'
    UseMask = b'UsMs'
    UserMaskEnabled = b'UsrM'
    UserMaskLinked = b'Usrs'
    LinkEnable = b'lnkE'
    Using = b'Usng'
    Value = b'Vl  '
    Variance = b'Vrnc'
    Vector0 = b'Vct0'
    Vector1 = b'Vct1'
    VectorColor = b'VctC'
    VersionFix = b'VrsF'
    VersionMajor = b'VrsM'
    VersionMinor = b'VrsN'
    Vertical = b'Vrtc'
    VerticalScale = b'VrtS'
    VideoAlpha = b'Vdlp'
    Visible = b'Vsbl'
    WatchSuspension = b'WtcS'
    Watermark = b'watr'
    WaveType = b'Wvtp'
    WavelengthMax = b'WLMx'
    WavelengthMin = b'WLMn'
    WebdavPrefs = b'WbdP'
    WetEdges = b'Wtdg'
    What = b'What'
    WhiteClip = b'WhtC'
    WhiteIntensity = b'WhtI'
    WhiteIsHigh = b'WhHi'
    WhiteLevel = b'WhtL'
    WhitePoint = b'WhtP'
    WholePath = b'WhPt'
    Width = b'Wdth'
    WindMethod = b'WndM'
    With = b'With'
    WorkPath = b'WrPt'
    WorkPathIndex = b'WrkP'
    X = b'X   '
    Y = b'Y   '
    Yellow = b'Ylw '
    ZigZagType = b'ZZTy'
    LegacySerialString = b'lSNs'


class P(bytes, _Enum):
    """
    P definitions extracted from PITerminology.h.

    See https://www.adobe.com/devnet/photoshop/sdk.html
    """
    Inherits = b'c@#^'


class Type(bytes, _Enum):
    """
    Type definitions extracted from PITerminology.h.

    See https://www.adobe.com/devnet/photoshop/sdk.html
    """
    ActionReference = b'#Act'
    ActionData = b'ActD'
    AlignDistributeSelector = b'ADSt'
    Alignment = b'Alg '
    Amount = b'Amnt'
    AntiAlias = b'Annt'
    AreaSelector = b'ArSl'
    AssumeOptions = b'AssO'
    BevelEmbossStampStyle = b'BESs'
    BevelEmbossStyle = b'BESl'
    BitDepth = b'BtDp'
    BlackGeneration = b'BlcG'
    BlendMode = b'BlnM'
    BlurMethod = b'BlrM'
    BlurQuality = b'BlrQ'
    BrushType = b'BrsT'
    BuiltinProfile = b'BltP'
    BuiltInContour = b'BltC'
    CMYKSetupEngine = b'CMYE'
    Calculation = b'Clcn'
    Channel = b'Chnl'
    ChannelReference = b'#ChR'
    CheckerboardSize = b'Chck'
    ClassColor = b'#Clr'
    ClassElement = b'#ClE'
    ClassExport = b'#Cle'
    ClassFormat = b'#ClF'
    ClassHueSatHueSatV2 = b'#HsV'
    ClassImport = b'#ClI'
    ClassMode = b'#ClM'
    ClassStringFormat = b'#ClS'
    ClassTextExport = b'#CTE'
    ClassTextImport = b'#ClT'
    Color = b'Clr '
    ColorChannel = b'#ClC'
    ColorPalette = b'ClrP'
    ColorSpace = b'ClrS'
    ColorStopType = b'Clry'
    Colors = b'Clrs'
    Compensation = b'Cmpn'
    ContourEdge = b'CntE'
    Convert = b'Cnvr'
    CorrectionMethod = b'CrcM'
    CursorKind = b'CrsK'
    DCS = b'DCS '
    DeepDepth = b'DpDp'
    Depth = b'Dpth'
    DiffuseMode = b'DfsM'
    Direction = b'Drct'
    DisplacementMap = b'DspM'
    Distribution = b'Dstr'
    Dither = b'Dthr'
    DitherQuality = b'Dthq'
    DocumentReference = b'#DcR'
    EPSPreview = b'EPSP'
    ElementReference = b'#ElR'
    Encoding = b'Encd'
    EraserKind = b'ErsK'
    ExtrudeRandom = b'ExtR'
    ExtrudeType = b'ExtT'
    EyeDropperSample = b'EyDp'
    FPXCompress = b'FxCm'
    Fill = b'Fl  '
    FillColor = b'FlCl'
    FillContents = b'FlCn'
    FillMode = b'FlMd'
    ForcedColors = b'FrcC'
    FrameFill = b'FrFl'
    FrameStyle = b'FStl'
    GIFColorFileType = b'GFPT'
    GIFPaletteType = b'GFPL'
    GIFRequiredColorSpaceType = b'GFCS'
    GIFRowOrderType = b'GFIT'
    GlobalClass = b'GlbC'
    GlobalObject = b'GlbO'
    GradientType = b'GrdT'
    GradientForm = b'GrdF'
    GrainType = b'Grnt'
    GrayBehavior = b'GrBh'
    GuideGridColor = b'GdGr'
    GuideGridStyle = b'GdGS'
    HistoryStateSource = b'HstS'
    HorizontalLocation = b'HrzL'
    ImageReference = b'#ImR'
    InnerGlowSource = b'IGSr'
    IntegerChannel = b'#inC'
    Intent = b'Inte'
    InterlaceCreateType = b'IntC'
    InterlaceEliminateType = b'IntE'
    Interpolation = b'Intp'
    Kelvin = b'Klvn'
    KelvinCustomWhitePoint = b'#Klv'
    Lens = b'Lns '
    LightDirection = b'LghD'
    LightPosition = b'LghP'
    LightType = b'LghT'
    LocationReference = b'#Lct'
    MaskIndicator = b'MskI'
    MatteColor = b'MttC'
    MatteTechnique = b'BETE'
    MenuItem = b'MnIt'
    Method = b'Mthd'
    MezzotintType = b'MztT'
    Mode = b'Md  '
    Notify = b'Ntfy'
    Object = b'Objc'
    ObjectReference = b'obj '
    OnOff = b'OnOf'
    Ordinal = b'Ordn'
    Orientation = b'Ornt'
    PNGFilter = b'PNGf'
    PNGInterlaceType = b'PGIT'
    PagePosition = b'PgPs'
    PathKind = b'PthK'
    PathReference = b'#PtR'
    Phosphors = b'Phsp'
    PhosphorsCustomPhosphors = b'#Phs'
    PickerKind = b'PckK'
    PixelPaintSize = b'PPSz'
    Platform = b'Pltf'
    Preview = b'Prvw'
    PreviewCMYK = b'Prvt'
    ProfileMismatch = b'PrfM'
    PurgeItem = b'PrgI'
    QuadCenterState = b'QCSt'
    Quality = b'Qlty'
    QueryState = b'QurS'
    RGBSetupSource = b'RGBS'
    RawData = b'tdta'
    RippleSize = b'RplS'
    RulerUnits = b'RlrU'
    ScreenType = b'ScrT'
    Shape = b'Shp '
    SmartBlurMode = b'SmBM'
    SmartBlurQuality = b'SmBQ'
    SourceMode = b'Cndn'
    SpherizeMode = b'SphM'
    State = b'Stte'
    StringClassFormat = b'#StC'
    StringChannel = b'#sth'
    StringCompensation = b'#Stm'
    StringFSS = b'#Stf'
    StringInteger = b'#StI'
    StrokeDirection = b'StrD'
    StrokeLocation = b'StrL'
    TextureType = b'TxtT'
    TransparencyGridColors = b'Trnl'
    TransparencyGridSize = b'TrnG'
    TypeClassModeOrClassMode = b'#TyM'
    UndefinedArea = b'UndA'
    UnitFloat = b'UntF'
    Urgency = b'Urgn'
    UserMaskOptions = b'UsrM'
    ValueList = b'VlLs'
    VerticalLocation = b'VrtL'
    WaveType = b'Wvtp'
    WindMethod = b'WndM'
    YesNo = b'YsN '
    ZigZagType = b'ZZTy'


class Unit(bytes, _Enum):
    """
    Unit definitions extracted from PITerminology.h.

    See https://www.adobe.com/devnet/photoshop/sdk.html
    """
    Angle = b'#Ang'
    Density = b'#Rsl'
    Distance = b'#Rlt'
    _None = b'#Nne'
    Percent = b'#Prc'
    Pixels = b'#Pxl'
    Millimeters = b'#Mlm'
    Points = b'#Pnt'
