import importlib.resources as imp_resources

from PySide import QtWidgets

import library.ui.style_sheets as style_sheets
import library.ui.style_sheets.colors as stylesheet_colors

import substance_painter.project as sp_project
import substance_painter.ui as sp_ui

def application_main_window():
    return None

def file_name():
    print( "# multiplatform.api: get current scene file name" )
    path = sp_project.file_path()
    return path

def file_new():
    print( "# multiplatform.api: clear current scene" )

def file_open(path):
    print( "# multiplatform.api: open given scene" )
    sp_project.open(path)

def file_rename(path):
    path = sp_project.save_as(path)

def file_save( rename_to = None ):
    if not sp_project.is_open():
        return

    print( "# multiplatform.api: save current scene" )
    if rename_to:
        sp_project.execute_when_not_busy(sp_project.save_as(rename_to))


    else:
        sp_project.execute_when_not_busy(sp_project.save())



def playblast( workflowTaskType ):
    print( "# multiplatform.api: get current scene file name" )

def scan_file():
    print("# multiplatform.api: get current scene elements")
    return []

class MainWindow(QtWidgets.QMainWindow):
    def __init__( self, title, style_sheet='square_style'):
        host = sp_ui.get_main_window()
        QtWidgets.QMainWindow.__init__(self, parent=host)
        self.title = title
        self.style_sheet = style_sheet
        self.setWindowTitle(self.title)
        self.setContentsMargins(0, 0, 0, 0)

    def apply_style(self, central_widget):
        style_sheet_resolver = imp_resources.files(style_sheets)
        with imp_resources.as_file(style_sheet_resolver) as path:
            style_sheet_path = '%s/%s.qss' % (path, self.style_sheet)
        colors = stylesheet_colors.stylesheet_color()

        with open(style_sheet_path, mode='r') as f:
            _style = f.read()

            for key, value in colors.items():
                _style = _style.replace('<%s>' % key, value)
            central_widget.setStyleSheet(_style)

def set_scene_settings(entity_data):
    pass


if __name__ == '__main__':
    style_sheet_resolver = imp_resources.files(style_sheets)
    style_sheet_name = 'square_style'
    with imp_resources.as_file(style_sheet_resolver) as path:
        style_sheet_path = '%s/%s.qss' % (path, style_sheet_name)
    colors = stylesheet_colors.stylesheet_color()

    with open(style_sheet_path, mode='r') as f:
        _style = f.read()

    print(_style)