import importlib.resources as imp_resources

from PySide import QtWidgets

import library.ui.style_sheets as style_sheets
import library.ui.style_sheets.colors as stylesheet_colors


def application_main_window():
    return None

def file_name():
    print( "# multiplatform.api: get current scene file name" )
    return ""

def file_new():
    print( "# multiplatform.api: clear current scene" )

def file_open( path ):
    print( "# multiplatform.api: open given scene" )

def file_rename( path ):
    print( "# multiplatform.api: set current scene file name" )

def file_save( rename_to = None ):
    print( "# multiplatform.api: save current scene" )

def playblast( workflowTaskType ):
    print( "# multiplatform.api: get current scene file name" )

def scan_file():
    print("# multiplatform.api: get current scene elements")
    return []

class MainWindow(QtWidgets.QMainWindow):
    def __init__( self, title, style_sheet='square_style', parent=None):
        super(MainWindow, self).__init__(parent=parent)
        self.title = title
        self.style_sheet = style_sheet
        self.setWindowTitle(self.title)
        self.setContentsMargins(0, 0, 0, 0)

    def apply_style(self, central_widget):
        style_sheet_path = imp_resources.path(style_sheets, '%s.qss' % self.style_sheet)
        colors = stylesheet_colors.stylesheet_color()
        with style_sheet_path as colors_path:
            with open(colors_path, "r") as f:
                _style = f.read()

                for key, value in colors.items():
                    _style = _style.replace('<%s>' % key, value)
                central_widget.setStyleSheet(_style)
