import os
import sys
import logging

import importlib

print('load packages io')
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

logger.info('Loading packages io')
def get_application():
    app = os.path.splitext(os.path.basename(sys.executable))[0].lower()
    print(app)
    logger.info('Loading packages io for : %s' % app)

    return app


app_name = get_application()

if app_name == 'maya':
    print('import as maya package')
    import packages_io.maya as maya

    importlib.reload(maya)
    from packages_io.maya import *
elif app_name == 'mayapy':
    import packages_io.maya as maya

    importlib.reload(maya)
    print('import as mayapy package')
    from packages_io.maya import *
elif app_name == 'nuke':
    print('import as nuke package')
    from packages_io.nuke import *

elif app_name == 'adobe substance 3d painter':
    print('import as substance package')
    from packages_io.substance import *

else:
    print('import as default package')

    from packages_io.default import *

