import os
import subprocess
import importlib
import importlib.resources as resources

import movie_transfer.resources as movie_resources


def delete_from_file(frames_file):

    file_data = open(frames_file, 'r')

    for raw_line in file_data.readlines():
        line = raw_line.replace('\n', '')
        if line.startswith('file '):
            path = line.split("'")[1]

            os.remove(path)
    file_data.close()

    os.remove(frames_file)



def create_quicktime(path, outputPath,
                     top_left_text=None,
                     top_center_text=None,
                     top_right_text=None,
                     bottom_left_text=None,
                     bottom_center_text=None,
                     first_frame=101,
                     last_frame=148,
                     delete_sources=False,
                     aov_list=None
                     ):

    import movie_transfer.lib.movie_helpers as movie_helpers
    importlib.reload(movie_helpers)

    if not aov_list:
        aov_list = ['beauty']
    else:
        aov_list = aov_list[0].split(' ')

    basename = os.path.basename(path)
    if basename.find('.') > -1:
        path = os.path.dirname(path)
    total_frames = last_frame - first_frame + 1

    folder = os.path.dirname(path)
    temp_folder = folder
    txt_file_of_list_of_frames_to_render = movie_helpers.generate_list_of_existing_frames(first_frame,
                                                                                          last_frame,
                                                                                          path,
                                                                                          mode='w+',
                                                                                          aov_list=aov_list)
    burning_data = {}
    font_path = str(importlib.resources.path(movie_resources, 'Roboto-Bold.ttf'))
    font_path = 'C:/Windows/Fonts/Arial.ttf'
    font_path = font_path.replace('\\', '/')

    print(os.path.exists(font_path), font_path)
    base_burning_data = {'font': 'Arial',
                         'fontcolor': 'white',
                         'fontsize': '30',
                         'box': '1',
                         'boxcolor': 'black@0.2',
                         'boxborderw': '9'
                         }

    burning_data['bottom_right'] = base_burning_data.copy()
    burning_data['bottom_right']['text'] = '"%%{frame_num}/%i"' % (total_frames * len(aov_list))
    burning_data['bottom_right']['x'] = 'w-200'
    burning_data['bottom_right']['y'] = 'h-60'

    if top_left_text:
        burning_data['top_left'] = base_burning_data.copy()
        burning_data['top_left']['text'] = '"%s"' % top_left_text
        burning_data['top_left']['x'] = '(w)/40'
        burning_data['top_left']['y'] = '20'

    if top_center_text:
        burning_data['top_center'] = base_burning_data.copy()
        burning_data['top_center']['text'] = '"%s"' % top_center_text
        burning_data['top_center']['x'] = '(w-text_w)/2'
        burning_data['top_center']['y'] = '20'

        burning_data['top_center']['fontsize'] = '50'

    if top_right_text:
        burning_data['top_right'] = base_burning_data.copy()
        burning_data['top_right']['text'] = '"%s"' % top_right_text
        burning_data['top_right']['x'] = 'w-200'
        burning_data['top_right']['y'] = '20'

        burning_data['top_center']['fontsize'] = '50'

    if bottom_left_text:
        burning_data['bottom_left'] = base_burning_data.copy()
        burning_data['bottom_left']['text'] = '"%s"' % bottom_left_text
        burning_data['bottom_left']['x'] = '(w)/40'
        burning_data['bottom_left']['y'] = 'h-60'

    if bottom_center_text:
        burning_data['bottom_center'] = base_burning_data.copy()
        burning_data['bottom_center']['text'] = '"%s"' % bottom_left_text
        burning_data['bottom_center']['x'] = '(w-text_w)/2'
        burning_data['bottom_center']['y'] = 'h-60'


    burning_list = []
    for key, data in burning_data.items():
        string_list = []
        for label, value in data.items():
            string_list.append('%s=%s' % (label, value))
        values = ':'.join(string_list)
        burning_string = 'drawtext=%s' % values
        burning_list.append(burning_string)

    if len(burning_list) == 1:
        burning_str = burning_list[0]
    else:
        burning_str = '[in]%s[out]' % ','.join(burning_list)

    codec_name = 'prores_ks'
    ffmpeg_colorspace = ''
    framerate = 25
    ffMpgCmd_list = [r'\\company/company/tools/ffmpeg/chocolatey/bin/ffmpeg.exe',
                     '-loglevel', 'debug',
                     '-f','concat',
                     '-safe', '0',
                     '-y', ffmpeg_colorspace,
                     '-i', txt_file_of_list_of_frames_to_render,
                     '-c:v', codec_name,
                     '-profile:v', '1',
                     '-r', framerate,
                     '-vf', burning_str,
                     outputPath]

    if os.path.exists(outputPath):
        os.remove(outputPath)

    ffMpgCmd_list = [str(arg) for arg in ffMpgCmd_list]

    ffMpgCmd = ' '.join(ffMpgCmd_list)
    sp = subprocess.Popen( ffMpgCmd, stderr = subprocess.PIPE, env=os.environ.copy() )  # FFmpeg uses stderr in place of stdout

    out, err = sp.communicate()
    if out:
        print("standard output of subprocess b:")
        for line in str(out.decode("utf-8")).split('\n'):
            print(line)
    if err:
        print("standard error of subprocess b:")
        print(err)
        for line in str(err.decode("utf-8")).split('\n'):
            print(line)


    if delete_sources:
        delete_from_file(txt_file_of_list_of_frames_to_render)


def test_builder():

    images = 'V:/TPT/publish/shading/Secondary_Characters/Blob/Master/Blob_Master_00a118dfaee6ff98/v007/turntable'
    output = 'V:/TPT/publish/shading/Secondary_Characters/Blob/Master/Blob_Master_00a118dfaee6ff98/v007/turntable/Blob_test.mov'
    start = 101
    end = 124
    aov_list = ['RGBA_interior', 'RGBA_exterior']
    create_quicktime(images,
                     output,
                     top_center_text='top center',
                     top_left_text='top left',
                     bottom_left_text='bottom left',
                     delete_sources=False,
                     aov_list=aov_list)

if __name__ == '__main__':
    import argparse
    print('running quicktime')
    parser = argparse.ArgumentParser(description='Shotgun event launcher')
    parser.add_argument('-i', '-images', '--source-images', dest='images', help='Source images path')
    parser.add_argument('-o', '-output', '--output-path', dest='output', help='Output quicktime path')

    parser.add_argument('-tl', '-topleft', '--topleft-text', dest='top_left_text', help='Top left caption')
    parser.add_argument('-tc', '-topcenter', '--topcenter-text', dest='top_center_text', help='Top center caption')
    parser.add_argument('-bl', '-bottomleft', '--bottomleft-text', dest='bottom_left_text', help='Top left caption')

    parser.add_argument('-s', '-start', '--start-frame', dest='first_frame', default=101, type=int, help='First frame of the turntable')
    parser.add_argument('-e', '-end', '--end-frame', dest='last_frame', default=148, type=int,
                        help='Last frame of the turntable')

    parser.add_argument('-a', '-aov', '--aov-list', dest='aov_list', default=['beauty'], nargs='+', help='List of aov')


    args = parser.parse_args()

    create_quicktime(args.images,
                     args.output,
                     top_center_text=args.top_center_text,
                     top_left_text=args.top_left_text,
                     bottom_left_text=args.bottom_left_text,
                     first_frame=args.first_frame,
                     last_frame=args.last_frame,
                     delete_sources=False,
                     aov_list=args.aov_list)
