import os
import re
from pprint import pprint
import glob


def get_layer_frames(first_frame, last_frame, img_folder, aov_list):
    image_name = re.compile('([a-zA-Z0-9_]*).[0-9]*.exr')
    image_png_name = re.compile('([a-zA-Z0-9_]*).[0-9]*.png')

    frames = {}

    for aov in aov_list:

        full_folder = '%s/%s' % (img_folder, aov)
        print('check folder', aov, full_folder)
        if not os.path.exists(full_folder) or not os.path.isdir(full_folder):
            continue
        frames[aov] = []
        for basename in os.listdir(full_folder):
            print(basename)
            match_exr = image_name.match(basename)
            match_png = image_png_name.match(basename)
            if match_exr or match_png:
                full_frame = '%s/%s' % (full_folder, basename)
                frames[aov].append(full_frame)

    """
    basename = os.path.basename(full_file_path)

    basename_bits = basename.split('.')
    master_name = basename_bits[0]
    extension = basename_bits[-1]

    for file_name in os.listdir(img_folder):
        filename_bits = file_name.split('.')
        if filename_bits[0] != master_name:
            continue
        if filename_bits[-1] != extension:
            continue

        if not filename_bits[-2].isdigit():
            continue
        current_frame = int(filename_bits[-2])
        if current_frame > last_frame or current_frame < first_frame:
            continue

        if len(filename_bits) == 4:
            layer_type = filename_bits[1]
        else:
            layer_type = ''

        full_frame_path = os.path.join(img_folder, file_name)
        full_frame_path = full_frame_path.replace('\\', '/')
        if layer_type not in frames:
            frames[layer_type] = [full_frame_path]
        else:
            frames[layer_type].append(full_frame_path)
    """
    return frames

def generate_list_of_existing_frames(first_frame, last_frame, folder_path, mode='w', frame_rate=25, aov_list=None):
    if not aov_list:
        aov_list = ['beauty']
    frames = get_layer_frames(first_frame, last_frame, folder_path, aov_list)
    txt_file_path = folder_path + '/frame_list.txt'  # to be reverted , for TEST
    duration = 'duration ' + str(1 / float(frame_rate))

#    if isinstance(aov_list, str):

    with open(txt_file_path, mode) as f:
        for layer_name in aov_list:
            for frame_path in sorted(frames[layer_name]):

                line = 'file ' + "'" + frame_path + "'"
                if mode != 'r+' or line not in f.readlines():
                    f.write('%s\n' % line)
                    f.write('%s\n' % duration)

    return txt_file_path

if __name__ == '__main__':
    first_frame = 101
    last_frame = 108
    folder_path = 'V:/SGD/publish/model/Main_Characters/LeoMesi/Master/LeoMesi_Master_30ef6018a08b4458/v125/turntable'
    aovs = ['beauty']
    aovs = ['Occlusion', 'Wireframe']
    frames_file = generate_list_of_existing_frames(first_frame, last_frame, folder_path, aov_list=aovs)
    print(frames_file)