import importlib
import os
print('Loading user setup')

import maya.cmds as cmds

import packages_io
import launcher.lib.set_environment as set_environment
import library.ui.dcc_context_chooser as dcc_context_chooser


importlib.reload(set_environment)
print('Loading custom setup for maya')

def create_context_menu():
    print('Loading context chooser')
    global menu_builder
    project = os.environ['PROJECT']
    menu_builder = dcc_context_chooser.DccContextWidget(project=project)
    menu_builder.create_menu()
    return menu_builder

def set_project_config(project_name=None):
    if project_name is None:
        project_name = os.environ['PROJECT']

    print('Loading config for project %s' % project_name)
    project_environment = set_environment.ProjectEnvironment(project=project_name)

    project_data = project_environment.project_config
    print('Fps: %s %s' % (project_data['fps'], project_data['fps_name']))
    os.environ['PROJECT_FPS'] = project_data['fps_name']
    cmds.optionVar(sv=['workingUnitTime', project_data['fps_name']])
    cmds.optionVar(sv=['workingUnitTimeDefault', project_data['fps_name']])



def set_scene_config():
    fps = os.environ['PROJECT_FPS']
    cmds.currentUnit(t=fps)
    if cmds.objExists('hardwareRenderingGlobals'):

        cmds.setAttr('hardwareRenderingGlobals.defaultLightIntensity', 1.5)

def check_scene_config():
    print('check scene settings for project: %s' % os.environ['PROJECT'])
    project_fps = os.environ['PROJECT_FPS']
    print('show FPS: %s' % project_fps)
    scene_fps = cmds.currentUnit(t=True, q=True)
    if project_fps != scene_fps:
        result = cmds.confirmDialog(
            title='Wrong scene settings.',
            message='The scene frame per second is wrong.\n The current value is %s and should be %s, please change it' % (scene_fps, project_fps),
            button=['OK'],
            defaultButton='OK')
    else:
        print('The scene settings are correct')
    if cmds.objExists('hardwareRenderingGlobals'):
        cmds.setAttr('hardwareRenderingGlobals.defaultLightIntensity', 1.5)

def load_default_plugins():
    print('Loading default plugins')

    #cmds.loadPlugin('AbcExport')

    #cmds.loadPlugin('gpuCache')
    #cmds.loadPlugin('assembly.py')
    cmds.loadPlugin('set_assembly.py')
    cmds.loadPlugin('rig_assembly.py')
    cmds.loadPlugin('usd_assembly.py')
    cmds.loadPlugin('mayaUsdPlugin')
    cmds.loadPlugin('mtoa')

    cmds.loadPlugin('atomImportExport')
    cmds.loadPlugin('enum_to_string.py')

    cmds.optionVar(sv=["UsdSelectionKind", "Component"])


def open_task_manager():
    cmds.loadPlugin('maya_drop_catcher.py')
    import task_manager.lib.dockable_widget as tm
    context_menu = create_context_menu()
    project = os.environ['PROJECT']
    print('Set project database to: %s' % project)
    tm_window = tm.set_task_manager(project, menu_builder=context_menu, threaded=False)


def add_callbacks():
    print('Adding script jobs')
    #jobNum = cmds.scriptJob(e=["SceneOpened", "select_sandbox()"], protected=True)
    cmds.scriptJob(event=["NewSceneOpened", "set_scene_config()"])
    cmds.scriptJob(event=["SceneOpened", "check_scene_config()"])

cmds.dirmap(en=True)
cmds.dirmap(m=('V:/TPT', '//columbus/SGD/TPT'))
cmds.dirmap(m=('V:/tpt', '//columbus/SGD/TPT'))
cmds.dirmap(m=('v:/tpt', '//columbus/SGD/TPT'))
cmds.dirmap(m=('v:/TPT', '//columbus/SGD/TPT'))

print('Loading user setup')
application = packages_io.get_application()

cmds.evalDeferred("set_project_config()")
cmds.evalDeferred("load_default_plugins()")

if application == 'maya':
    cmds.evalDeferred("open_task_manager()")
    cmds.evalDeferred("add_callbacks()")

#os.environ['MAYA_USD_VERSION'] = '0.22.11'