import maya.api.OpenMaya as om
import math


def maya_useNewAPI():
    pass


class SimpleNode(om.MPxNode):
    node_name = 'simpleNode'
    node_id =  om.MTypeId(70021)
    in_integer = None
    num_pad = None
    out_string = None

    def __init__(self):
        om.MPxNode.__init__(self)

    @staticmethod
    def creator():
        return SimpleNode()

    @staticmethod
    def initialize():
        num_attr = om.MFnNumericAttribute()

        SimpleNode.in_integer = num_attr.create('inInteger', 'ii', om.MFnNumericData.kInt, 1001)
        num_attr.storable = True
        om.MPxNode.addAttribute(SimpleNode.in_integer)

        SimpleNode.num_pad = num_attr.create('numPad', 'np', om.MFnNumericData.kInt, 4)
        num_attr.storable = True
        om.MPxNode.addAttribute(SimpleNode.num_pad)

        tAttr = om.MFnTypedAttribute()

        SimpleNode.out_string = tAttr.create('outString', 'os', om.MFnData.kString)
        #tAttr.setStorable(True)
        #tAttr.setWritable(True)
        om.MPxNode.addAttribute(SimpleNode.out_string)



        om.MPxNode.attributeAffects(SimpleNode.in_integer, SimpleNode.out_string)
        om.MPxNode.attributeAffects(SimpleNode.num_pad, SimpleNode.out_string)

    def compute(self, plug, data):
        # type: (om.MPlug, om.MDataBlock) -> None

        state = om.MFnDependencyNode(self.thisMObject()).findPlug('nodeState', False).asInt()
        if state == 1:
            data.outputValue(SimpleNode.a_val).setFloat(data.inputValue(SimpleNode.a_arg).asFloat())
            return

        if plug == SimpleNode.out_string:
            input_int = data.inputValue(SimpleNode.in_integer).asInt()
            padding = data.inputValue(SimpleNode.num_pad).asInt()

            padd_template = '%0' + str(padding) + 'd'
            out_string = padd_template % input_int
            val_handle = data.outputValue(SimpleNode.out_string)  # type: om.MDataHandle

            val_handle.setString(out_string)
            data.setClean(plug)


def initializePlugin(obj):
    fn_plugin = om.MFnPlugin(obj, 'ilya radovilsky', '1.0')
    fn_plugin.registerNode(SimpleNode.node_name, SimpleNode.node_id, SimpleNode.creator, SimpleNode.initialize)


def uninitializePlugin(obj):
    fn_plugin = om.MFnPlugin(obj)
    fn_plugin.deregisterNode(SimpleNode.node_id)