import maya.api.OpenMaya as om
import math

def maya_useNewAPI():
    pass


class EnumToString(om.MPxNode):
    node_name = 'enumToString'
    node_id =  om.MTypeId(70022)
    in_integer = None
    num_pad = None
    out_string = None

    def __init__(self):
        om.MPxNode.__init__(self)

    @staticmethod
    def creator():
        return EnumToString()

    @staticmethod
    def initialize():
        num_attr = om.MFnNumericAttribute()

        EnumToString.in_integer = num_attr.create('inInteger', 'ii', om.MFnNumericData.kInt, 1001)
        num_attr.storable = True
        om.MPxNode.addAttribute(EnumToString.in_integer)


        tAttr = om.MFnTypedAttribute()

        EnumToString.pattern = tAttr.create('pattern', 'pa', om.MFnData.kString)
        # tAttr.setStorable(True)
        # tAttr.setWritable(True)
        om.MPxNode.addAttribute(EnumToString.pattern)


        EnumToString.enum_values = tAttr.create('enumValues', 'ev', om.MFnData.kString)
        #tAttr.setStorable(True)
        #tAttr.setWritable(True)
        om.MPxNode.addAttribute(EnumToString.enum_values)


        EnumToString.out_string = tAttr.create('outString', 'os', om.MFnData.kString)
        #tAttr.setStorable(True)
        #tAttr.setWritable(True)
        om.MPxNode.addAttribute(EnumToString.out_string)

        EnumToString.out_pattern = tAttr.create('outPattern', 'op', om.MFnData.kString)
        # tAttr.setStorable(True)
        # tAttr.setWritable(True)
        om.MPxNode.addAttribute(EnumToString.out_pattern)


        om.MPxNode.attributeAffects(EnumToString.in_integer, EnumToString.out_string)
        om.MPxNode.attributeAffects(EnumToString.enum_values, EnumToString.out_string)

        om.MPxNode.attributeAffects(EnumToString.in_integer, EnumToString.out_pattern)
        om.MPxNode.attributeAffects(EnumToString.enum_values, EnumToString.out_pattern)

        om.MPxNode.attributeAffects(EnumToString.out_string, EnumToString.out_pattern)

    def compute(self, plug, data):
        # type: (om.MPlug, om.MDataBlock) -> None

        state = om.MFnDependencyNode(self.thisMObject()).findPlug('nodeState', False).asInt()
        if state == 1:
            data.outputValue(EnumToString.a_val).setFloat(data.inputValue(EnumToString.a_arg).asFloat())
            return

        if plug == EnumToString.out_string:
            input_int = data.inputValue(EnumToString.in_integer).asInt()

            enum_values_raw = data.inputValue(EnumToString.enum_values).asString()

            if not enum_values_raw:
                return


            enum_values = enum_values_raw.split(':')
            if input_int > len(enum_values):
                return

            out_string = enum_values[input_int]
            val_handle = data.outputValue(EnumToString.out_string)  # type: om.MDataHandle
            val_handle.setString(out_string)
            data.setClean(plug)

        if plug == EnumToString.out_pattern:
            token_raw = data.inputValue(EnumToString.out_string).asString()
            pattern = data.inputValue(EnumToString.pattern).asString()

            bits = pattern.split('>')
            solved_list = []
            for bit in bits:
                next_pos = bit.find('<')
                if next_pos == -1:
                    solved_list.append(bit)
                else:
                    string = bit[:next_pos]+token_raw
                    solved_list.append(string)
            out_pattern = ''.join(solved_list)
            val_handle = data.outputValue(EnumToString.out_pattern)  # type: om.MDataHandle

            val_handle.setString(out_pattern)
            data.setClean(plug)


def initializePlugin(obj):
    fn_plugin = om.MFnPlugin(obj, 'ilya radovilsky', '1.0')
    fn_plugin.registerNode(EnumToString.node_name, EnumToString.node_id, EnumToString.creator, EnumToString.initialize)


def uninitializePlugin(obj):
    fn_plugin = om.MFnPlugin(obj)
    fn_plugin.deregisterNode(EnumToString.node_id)