import importlib
from pprint import pprint

import maya.cmds as cmds

LAYER_TO_STEP = {'model': 'Model',
                 'shading': 'Shading',
                 'shader': 'Shading',
                 }

def get_usd_assembly():
    all_inputs = {}
    for node in cmds.ls(type='UsdAssembly'):
        print(node)
        asset_name = cmds.getAttr('%s.assetName' % node)
        asset_type = cmds.getAttr('%s.assetType' % node)

        asset_name = asset_name[0].upper()+asset_name[1:]
        alias = node.rsplit('_', 1)[0]
        path = cmds.getAttr('%s.usdPath' % node)

        all_attributes = cmds.listAttr(node)
        print(asset_name)
        for attribute in all_attributes:
            if not  attribute.endswith('_variant'):
                continue

            layer = attribute.rsplit('_', 1)[0]
            print(layer)
            variant_attr = attribute
            version_attr = '%s_version' % layer

            variant = cmds.getAttr('%s.%s' % (node, variant_attr), asString=True)
            version = cmds.getAttr('%s.%s' % (node, version_attr), asString=True)
            step = LAYER_TO_STEP.get(layer, layer)
            if version.isdigit():
                version = int(version)

            all_inputs[asset_name] = all_inputs.get(asset_name, {})
            all_inputs[asset_name][alias] = all_inputs[asset_name].get(alias, {})
            all_inputs[asset_name][alias][step] = {'variant': variant,
                                                   'version_number': version,
                                                   'path': path,
                                                   'asset_name': asset_name,
                                                   'code': asset_name,
                                                   'asset_type': asset_type,
                                                   'loader_type': 'usd assembly',
                                                   'type': 'Asset',
                                                   'node': node,
                                                   'step': step,
                                                   'layer': layer
                                                   }

    return all_inputs

def set_usd_assembly(node_data, publish_view):
    pprint(node_data)
    node_name = node_data['node']
    layer_name = node_data['layer']

    variant_name = publish_view.sg_variant_name

    version_number = publish_view.sg_version_number

    if isinstance(version_number, int):
        version_number = '%03d' % version_number
    variant_attr = '%s_variant' % layer_name
    version_attr = '%s_version' % layer_name

    variant_list = cmds.attributeQuery(variant_attr, n=node_name, le=True)[0].split(':')
    print(variant_list)
    variant_index = variant_list.index(variant_name)

    version_list = cmds.attributeQuery(version_attr, n=node_name, le=True)[0].split(':')
    print(version_list)
    version_index = version_list.index(version_number)

    cmds.setAttr('%s.%s' % (node_name, variant_attr), variant_index)

    cmds.setAttr('%s.%s' % (node_name, version_attr), version_index)


def get_usd_shape(project):
    print('project', project)
    import usd.lib.usd_manager as usd_manager
    importlib.reload(usd_manager)

    all_inputs = {}
    for usd_shape in cmds.ls(type='mayaUsdProxyShape'):
        alias = usd_shape
        manager = usd_manager.UsdManager(project)
        stage = manager.get_stage_from_maya(usd_shape)
        default_prim = manager.default_prim
        variants = manager.get_layer_variants()
        asset_name = manager.get_attribute(default_prim, 'atlantis:asset_name')
        asset_type = manager.get_attribute(default_prim, 'atlantis:asset_type')
        path = cmds.getAttr('%s.filePath' % usd_shape)
        all_inputs[asset_name] = all_inputs.get(asset_name, {})
        all_inputs[asset_name][alias] = all_inputs[asset_name].get(alias, {})

        print(asset_name)
        pprint(variants)
        for variant_name in variants:
            if not variant_name.endswith('_variant'):
                continue
            step = variant_name.rsplit('_', 1)[0]

            step = step[0].upper() + step[1:]
            selected_variant = manager.get_selected_variant(default_prim, variant_name)
            version_var_name = variant_name.replace('_variant', '_version')
            selected_version = manager.get_selected_variant(default_prim, version_var_name)
            layer = None
            step_data = {'variant': selected_variant,
                         'version_number': selected_version,
                         'path': path,
                         'asset_name': asset_name,
                         'code': asset_name,
                         'asset_type': asset_type,
                         'loader_type': 'usd shape',
                         'type': 'Asset',
                         'node': usd_shape,
                         'step': step,
                         'layer': layer
                         }
            pprint(step_data)
            all_inputs[asset_name][alias][step] = step_data.copy()
    return all_inputs

def set_usd_shape(node_data, publish_view, project=None):
    import usd.lib.usd_manager as usd_manager
    importlib.reload(usd_manager)

    pprint(node_data)
    node_name = node_data['node']

    layer_name = node_data['layer']

    variant_name = publish_view.sg_variant_name

    pipeline_step = node_data['step']
    pipeline_step = pipeline_step[0].lower() + pipeline_step[1:]

    variant_set_name = '%s_variant' % pipeline_step
    version_set_name = '%s_version' % pipeline_step


    version_number = publish_view.sg_version_number

    if isinstance(version_number, int):
        version_number = '%03d' % version_number


    manager = usd_manager.UsdManager(project)
    manager.get_stage_from_maya(node_name)
    default_prim = manager.default_prim
    manager.set_prim_variant(default_prim, variant_set_name, variant_name)
    manager.set_prim_variant(default_prim, version_set_name, version_number)

#manager.set_attribute(manager.default_prim, 'atlantis:set_variant', variant_name)
#s    manager.set_attribute(manager.default_prim, 'atlantis:set_version', int(version_number))

