import os
import maya.cmds as cmds
from pprint import pprint

def get_data_from_path(path, asset_name):
    # v:\TPT\publish\rig\Props\Joystick\Master\Joystick_Master_ce04e0091c7ea955\v001\rig\Joystick.mb
    path = path.replace('\\', '/')
    bits = path.split('/')
    version = 0
    for bit in bits:
        if bit[0] == 'v' and bit[1:].isdigit():
            version = int(bit[1:])
    index = bits.index(asset_name)
    variant = bits[index+1]

    return variant, version

def get_rig_assembly():
    all_inputs = {}
    for node in cmds.ls(type='RigAssembly'):
        asset_name = cmds.getAttr('%s.assetName' % node)
        asset_type = cmds.getAttr('%s.assetType' % node)

        alias = node.rsplit('_', 1)[0]
        path = cmds.getAttr('%s.rigPath' % node)
        variant = cmds.getAttr('%s.rigVariant' % node)
        version = cmds.getAttr('%s.rigVersion' % node)

        if path:
            if not version or not variant:
                variant, version = get_data_from_path(path, asset_name)

                cmds.setAttr('%s.rigVariant' % node, variant, type='string')
                cmds.setAttr('%s.rigVersion' % node, version, type='string')

        if version is None:
            version = 0
        all_inputs[asset_name] = all_inputs.get(asset_name, {})
        all_inputs[asset_name][alias] = {}
        all_inputs[asset_name][alias]['Rig'] = {'variant': variant,
                                                'version_number': int(version),
                                                'path': path,
                                                'asset_name': asset_name,
                                                'code': asset_name,
                                                'loader_type': 'rig assembly',
                                                'type': 'Asset',
                                                'node': node,
                                                'step': 'Rig'

                                                }
        if asset_name == 'Camera':
            continue
        shading_path = cmds.getAttr('%s.shadingPath' % node)
        if shading_path and os.path.exists(shading_path):
            shading_variant = cmds.getAttr('%s.shadingVariant' % node)
            shading_version = cmds.getAttr('%s.shadingVersion' % node)
        else:
            shading_variant = 'Master'
            shading_version = ''

        if not isinstance(shading_version, str) or shading_version.isdigit():
            shading_version = int(shading_version)

        all_inputs[asset_name][alias]['Shading'] = {'variant': shading_variant,
                                                    'version_number': shading_version,
                                                    'path': shading_path,
                                                    'asset_name': asset_name,
                                                    'code': asset_name,
                                                    'loader_type': 'rig assembly',
                                                    'type': 'Asset',
                                                    'node': node,
                                                    'step': 'Shading'
                                                    }

    return all_inputs


def update_rig_assembly(node_data, publish_view):
    node_name = node_data['node']
    rig = node_data['step'] == 'Rig'
    if rig:
        path = '%s/%s' % (publish_view.sg_published_folder, publish_view.sg_files['rig'])
    else:
        path = '%s/%s' % (publish_view.sg_published_folder, publish_view.sg_files['shaders'])
    if not os.path.exists(path):
        return

    import maya.cmds as cmds
    if rig:
        cmds.setAttr('%s.rigPath' % node_name, lock=False, e=True)
        cmds.setAttr('%s.rigPath' % node_name, path, type='string')
        cmds.setAttr('%s.rigPath' % node_name, lock=True, e=True)

        cmds.setAttr('%s.rigVariant' % node_name, lock=False, e=True)
        cmds.setAttr('%s.rigVariant' % node_name, publish_view.sg_variant_name, type='string')
        cmds.setAttr('%s.rigVariant' % node_name, lock=True, e=True)

        cmds.setAttr('%s.rigVersion' % node_name, lock=False, e=True)
        cmds.setAttr('%s.rigVersion' % node_name, publish_view.sg_version_number, type='string')
        cmds.setAttr('%s.rigVersion' % node_name, lock=True, e=True)


    else:
        cmds.setAttr('%s.shadingPath' % node_name, lock=False, e=True)
        cmds.setAttr('%s.shadingPath' % node_name, path, type='string')
        cmds.setAttr('%s.shadingPath' % node_name, lock=True, e=True)
        cmds.setAttr('%s.shadingVariant' % node_name, lock=False, e=True)
        cmds.setAttr('%s.shadingVariant' % node_name, publish_view.sg_variant_name, type='string')
        cmds.setAttr('%s.shadingVariant' % node_name, lock=True, e=True)

        cmds.setAttr('%s.shadingVersion' % node_name, lock=False, e=True)
        cmds.setAttr('%s.shadingVersion' % node_name, publish_view.sg_version_number, type='string')
        cmds.setAttr('%s.shadingVersion' % node_name, lock=True, e=True)
