import importlib
import packages_io

import maya_scene_manager.lib.scene_widget as scene_widget
import shotgrid_lib.database as database
from PySide import QtWidgets

importlib.reload(packages_io)
importlib.reload(scene_widget)

class SceneManagerWidget(QtWidgets.QWidget):
    def __init__(self, project, parent):
        super().__init__(parent=parent)

        self.project = project
        self.database = parent.database

        self.main_layout = QtWidgets.QVBoxLayout()
        self.data_widget = scene_widget.SceneTree(project=project, editable=True, parent=self)

        self.main_layout.addWidget(self.data_widget)
        self.setLayout(self.main_layout)


class SceneManagerWindow(packages_io.MainWindow):
    def __init__(self, project):
        title = 'Scene manager'
        super().__init__(title=title)
        self.project = project
        self.database = database.DataBase()
        self.setMinimumWidth(900)

        self.database.fill(self.project, precatch=False)
        self.database.query_sg_database('CustomEntity11', as_precache=True)

        self.main_widget = SceneManagerWidget(self.project, self)

        self.setCentralWidget(self.main_widget)



def open_scene_manager(task=None, project=None):
    entity = task.entity

    scene_manager = SceneManagerWindow(project)

    #scene_manager.start()
    scene_manager.show()
