import os

import maya.cmds as cmds
import maya.OpenMaya as OpenMaya

import maya_assemblies.lib.helpers as helpers
import maya_assemblies.lib.representations.representation as representation

class VFXRepresentation(representation.Representation):
    typename = "VFXRepresentation"
    def activate(self):
        assembly_name = self.get_assembly_name()
        vfx_path = self.assembly.fx_path
        extension = vfx_path.split('.')[-1]
        if extension == 'vdb':
            vfx_node = cmds.createNode('RedshiftVolumeShape', parent=assembly_name)
            cmds.setAttr('%s.fileName' % vfx_node, vfx_path, type='string')
            cmds.setAttr('%s.useFrameExtension' % vfx_node, 1)
            cmds.setAttr('%s.displayMode' % vfx_node, 2)

        elif extension == 'rs':
            vfx_geo_node = cmds.createNode('mesh', parent=assembly_name)

            vfx_node = cmds.createNode('RedshiftProxyMesh')
            cmds.connectAttr('%s.outMesh' % vfx_node, '%s.inMesh' % vfx_geo_node, f=True )
            cmds.setAttr('%s.fileName' % vfx_node, vfx_path, type='string')
            cmds.setAttr('%s.useFrameExtension' % vfx_node, 1)
            cmds.setAttr('%s.displayMode' % vfx_node, 1)
            cmds.setAttr('%s.materialMode' % vfx_node, 1)

            


        return True

    def can_apply_edits(self):
        return False


