import os
import importlib

import maya.cmds as cmds
import maya.OpenMaya as OpenMaya

from pxr import Usd, UsdGeom, Sdf


import maya_assemblies.lib.representations.representation as representation
import maya_assemblies.lib.shader_helpers as shader_helpers

importlib.reload(shader_helpers)


class UsdStageRepresentation(representation.Representation):
    typename = "usdStage"
    def activate(self):
        self.assembly.is_activating = True
        namespace = self.get_assembly_namespace()
        self.loaded_nodes = cmds.namespaceInfo(namespace, ls=True, dagPath=True)
        if self.loaded_nodes:
            cmds.delete(self.loaded_nodes)
        parent_assembly = self.get_assembly_name()
        shape_node = cmds.createNode('mayaUsdProxyShape', name='usdShape', parent=parent_assembly)
        cmds.setAttr('%s.filePath' % shape_node, self.path, type='string')
        return True
    def can_apply_edits(self):
        return True

