import os

import maya.cmds as cmds

import maya_assemblies.lib.representations.representation as representation




class LocatorRepresentation(representation.Representation):
    typename = 'Locator'

    def __init__(self, assembly, name, path, annotation=None):
        super(LocatorRepresentation, self).__init__(assembly, name, path)
        self.annotation = annotation

    def activate(self):
        assembly = self.get_assembly_name()
        cmds.createNode('locator', parent=assembly)

        if self.annotation is None:
            return True

        transform = cmds.createNode("transform", parent=assembly, name='annotation#')
        annotation = cmds.createNode("annotationShape", parent=transform, name='annotationShape')

        cmds.setAttr(annotation + '.text', self.annotation, type='string')
        cmds.setAttr(annotation + '.displayArrow', False)

        return True

    def can_apply_edits(self):
        return False